package com.boanda.android.sync;

import java.io.File;

/**
 * <p>Description: 混合了解析xml同步数据和json同步数据的解析器</p>
 * @author    Siyi Lu    Create Date: 2016年11月21日
 */
public class HybridSyncParser implements ISyncXmlParser, ISyncJsonParser{
	
	/**表标签*/
	public final static String TAG_TABLE = "table";
	
	private ISyncXmlParser mXmlParser;
	
	private ISyncJsonParser mJsonParser;
	
	public HybridSyncParser(ISyncXmlParser xmlParser) {
		mXmlParser = xmlParser;
	}
	
	public HybridSyncParser(ISyncJsonParser jsonParser) {
		mJsonParser = jsonParser;
	}

	@Override
	public boolean parseJson(File syncJsonFile) {
		return mJsonParser.parseJson(syncJsonFile);
	}

	@Override
	public boolean parseXml(File syncXmlFile) {
		return mXmlParser.parseXml(syncXmlFile);
	}
	
}
