/*
 * Decompiled with CFR 0.152.
 */
package com.boanda.android.graphic;

import android.content.Context;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import com.boanda.android.graphic.BitmapEngine;
import org.xutils.image.ImageOptions;

public class DisplayOption {
    private ImageOptions mActualOption;

    private DisplayOption(Builder builder) {
        this.mActualOption = builder.getOption();
    }

    public ImageOptions getActualOption() {
        return this.mActualOption;
    }

    public static class Builder {
        private ImageOptions.Builder mOptionBuilder = new ImageOptions.Builder();

        public Builder animate(int animationId) {
            Animation anim = AnimationUtils.loadAnimation((Context)BitmapEngine.getContext(), (int)animationId);
            this.mOptionBuilder.setAnimation(anim);
            return this;
        }

        public Builder autoRotate(boolean autoRotate) {
            this.mOptionBuilder.setAutoRotate(autoRotate);
            return this;
        }

        public Builder dimen(int width, int height) {
            this.mOptionBuilder.setSize(width, height);
            return this;
        }

        public Builder crop(boolean crop) {
            this.mOptionBuilder.setCrop(crop);
            return this;
        }

        public Builder fadeIn(boolean fadeIn) {
            this.mOptionBuilder.setFadeIn(fadeIn);
            return this;
        }

        public Builder failureDrawableId(int failureDrawableId) {
            this.mOptionBuilder.setFailureDrawableId(failureDrawableId);
            return this;
        }

        public Builder ignoreGif(boolean ignoreGif) {
            this.mOptionBuilder.setIgnoreGif(ignoreGif);
            return this;
        }

        public Builder loadingDrawableId(int loadingDrawableId) {
            this.mOptionBuilder.setLoadingDrawableId(loadingDrawableId);
            return this;
        }

        public Builder placeholderScaleType(ImageView.ScaleType type) {
            this.mOptionBuilder.setPlaceholderScaleType(type);
            return this;
        }

        public Builder radius(int radius) {
            this.mOptionBuilder.setRadius(radius);
            return this;
        }

        public Builder square(boolean square) {
            this.mOptionBuilder.setSquare(square);
            return this;
        }

        public Builder circular(boolean circular) {
            this.mOptionBuilder.setCircular(circular);
            return this;
        }

        public Builder scaleType(ImageView.ScaleType type) {
            this.mOptionBuilder.setImageScaleType(type);
            return this;
        }

        protected ImageOptions getOption() {
            return this.mOptionBuilder.build();
        }

        public DisplayOption build() {
            DisplayOption option = new DisplayOption(this);
            return option;
        }
    }
}

