package com.boanda.android.graphic.adaptee;

import android.content.Context;
import android.view.View;

import com.boanda.android.graphic.DisplayOption;
import com.boanda.android.graphic.ILoaderCallbak;

import java.lang.reflect.Method;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/1/20.
 */

public class FrescoLoader extends BitmapLoaderStub{

    private static boolean mLibEnable = false;

    @Override
    public void init(Context context) {
        try{
            Class<?> frescoCls = Class.forName("com.facebook.drawee.backends.pipeline.Fresco");
            Method initMethod = frescoCls.getMethod("initialize", Context.class);
            initMethod.invoke(null, context);
            mLibEnable = true;
        }catch(Exception e){
            e.printStackTrace();
        }
    }

    @Override
    public boolean enable() {
        return mLibEnable;
    }

    @Override
    public void load(View targetView, String uri, DisplayOption option, ILoaderCallbak callbak) {
        if(enable() && targetView != null){
            try{
                Class<?> draweeCls = Class.forName("com.facebook.drawee.view.SimpleDraweeView");
                Method setUriMethod = draweeCls.getMethod("setImageURI", String.class);
                setUriMethod.invoke(targetView, uri);
                if(callbak != null){
                    callbak.loadSuccess(uri);
                }
            }catch(Exception e){
                if(callbak != null){
                    callbak.loadFailure(uri, e);
                }
                e.printStackTrace();
            }
        }
    }
}
