package com.boanda.android.graphic;

import android.content.Context;
import android.util.Log;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/6.
 * @Company 深圳市博安达信息技术股份有限公司
 */

public class BitmapEngine {

    private static Context CONTEXT;

    private static Class<?> ADAPTEE_CLASS;

    public static void init(Context context, Class<?> adaptee){
        CONTEXT = context;
        ADAPTEE_CLASS = adaptee;
//        Object adapteeInstance = getAdaptee();
//        if(adapteeInstance != null && adapteeInstance instanceof IBitmapLoader){
//            ((IBitmapLoader)adapteeInstance).init(getContext());
//        }
    }

    public static Context getContext(){
        return CONTEXT;
    }

    public static IBitmapLoader getAdaptee(){
        IBitmapLoader adaptee = null;
        if(ADAPTEE_CLASS != null){
            try{
                Object intance = ADAPTEE_CLASS.newInstance();
                if(intance instanceof IBitmapLoader) {
                    adaptee = ((IBitmapLoader)intance);
                    adaptee.init(getContext());
                }
            }catch(Exception e){
                e.printStackTrace();
                Log.e("BitmapEngine", "创建的图片加载适配器必须包含一个默认构造器");
            }
        }
        return adaptee;
    }

    public static boolean classEnable(String clsName){
        boolean enable = false;
        try{
            Class.forName(clsName);
            enable = true;
        }catch (Exception e){
            e.printStackTrace();
        }
        return enable;
    }

}
