/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.graphics.RectF;
import com.artifex.mupdfdemo.TextProcessor;
import com.artifex.mupdfdemo.TextWord;
import java.util.ArrayList;

class TextSelector {
    private final TextWord[][] mText;
    private final RectF mSelectBox;

    public TextSelector(TextWord[][] text, RectF selectBox) {
        this.mText = text;
        this.mSelectBox = selectBox;
    }

    public void select(TextProcessor tp) {
        if (this.mText == null || this.mSelectBox == null) {
            return;
        }
        ArrayList<TextWord[]> lines = new ArrayList<TextWord[]>();
        TextWord[][] textWordArray = this.mText;
        int n = this.mText.length;
        int n2 = 0;
        while (n2 < n) {
            TextWord[] line = textWordArray[n2];
            if (line[0].bottom > this.mSelectBox.top && line[0].top < this.mSelectBox.bottom) {
                lines.add(line);
            }
            ++n2;
        }
        for (TextWord[] line : lines) {
            boolean firstLine = line[0].top < this.mSelectBox.top;
            boolean lastLine = line[0].bottom > this.mSelectBox.bottom;
            float start = Float.NEGATIVE_INFINITY;
            float end = Float.POSITIVE_INFINITY;
            if (firstLine && lastLine) {
                start = Math.min(this.mSelectBox.left, this.mSelectBox.right);
                end = Math.max(this.mSelectBox.left, this.mSelectBox.right);
            } else if (firstLine) {
                start = this.mSelectBox.left;
            } else if (lastLine) {
                end = this.mSelectBox.right;
            }
            tp.onStartLine();
            TextWord[] textWordArray2 = line;
            int n3 = line.length;
            int n4 = 0;
            while (n4 < n3) {
                TextWord word = textWordArray2[n4];
                if (word.right > start && word.left < end) {
                    tp.onWord(word);
                }
                ++n4;
            }
            tp.onEndLine();
        }
    }
}

