/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import com.artifex.mupdfdemo.Hit;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.LinkInfoExternal;
import com.artifex.mupdfdemo.LinkInfoInternal;
import com.artifex.mupdfdemo.LinkInfoRemote;
import com.artifex.mupdfdemo.LinkInfoVisitor;
import com.artifex.mupdfdemo.MuPDFView;
import com.artifex.mupdfdemo.ReaderView;
import com.artifex.mupdfdemo.SearchTaskResult;

public class MuPDFReaderView
extends ReaderView {
    private final Context mContext;
    private boolean mLinksEnabled = false;
    private Mode mMode = Mode.Viewing;
    private boolean tapDisabled = false;
    private int tapPageMargin;
    private float mX;
    private float mY;
    private static final float TOUCH_TOLERANCE = 2.0f;

    protected void onTapMainDocArea() {
    }

    protected void onDocMotion() {
    }

    protected void onHit(Hit item) {
    }

    public void setLinksEnabled(boolean b) {
        this.mLinksEnabled = b;
        this.resetupChildren();
    }

    public void setMode(Mode m) {
        this.mMode = m;
    }

    public MuPDFReaderView(Activity act) {
        super((Context)act);
        this.mContext = act;
        DisplayMetrics dm = new DisplayMetrics();
        act.getWindowManager().getDefaultDisplay().getMetrics(dm);
        this.tapPageMargin = (int)dm.xdpi;
        if (this.tapPageMargin < 100) {
            this.tapPageMargin = 100;
        }
        if (this.tapPageMargin > dm.widthPixels / 5) {
            this.tapPageMargin = dm.widthPixels / 5;
        }
    }

    @Override
    public boolean onSingleTapUp(MotionEvent e) {
        LinkInfo link = null;
        if (this.mMode == Mode.Viewing && !this.tapDisabled) {
            MuPDFView pageView = (MuPDFView)this.getDisplayedView();
            Hit item = pageView.passClickEvent(e.getX(), e.getY());
            this.onHit(item);
            if (item == Hit.Nothing) {
                if (this.mLinksEnabled && pageView != null && (link = pageView.hitLink(e.getX(), e.getY())) != null) {
                    link.acceptVisitor(new LinkInfoVisitor(){

                        @Override
                        public void visitInternal(LinkInfoInternal li) {
                            MuPDFReaderView.this.setDisplayedViewIndex(li.pageNumber);
                        }

                        @Override
                        public void visitExternal(LinkInfoExternal li) {
                            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)li.url));
                            MuPDFReaderView.this.mContext.startActivity(intent);
                        }

                        @Override
                        public void visitRemote(LinkInfoRemote li) {
                        }
                    });
                } else if (e.getX() < (float)this.tapPageMargin) {
                    super.smartMoveBackwards();
                } else if (e.getX() > (float)(super.getWidth() - this.tapPageMargin)) {
                    super.smartMoveForwards();
                } else if (e.getY() < (float)this.tapPageMargin) {
                    super.smartMoveBackwards();
                } else if (e.getY() > (float)(super.getHeight() - this.tapPageMargin)) {
                    super.smartMoveForwards();
                } else {
                    this.onTapMainDocArea();
                }
            }
        }
        return super.onSingleTapUp(e);
    }

    @Override
    public boolean onDown(MotionEvent e) {
        return super.onDown(e);
    }

    @Override
    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        MuPDFView pageView = (MuPDFView)this.getDisplayedView();
        switch (this.mMode) {
            case Viewing: {
                if (!this.tapDisabled) {
                    this.onDocMotion();
                }
                return super.onScroll(e1, e2, distanceX, distanceY);
            }
            case Selecting: {
                if (pageView != null) {
                    pageView.selectText(e1.getX(), e1.getY(), e2.getX(), e2.getY());
                }
                return true;
            }
        }
        return true;
    }

    @Override
    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        switch (this.mMode) {
            case Viewing: {
                return super.onFling(e1, e2, velocityX, velocityY);
            }
        }
        return true;
    }

    @Override
    public boolean onScaleBegin(ScaleGestureDetector d) {
        this.tapDisabled = true;
        return super.onScaleBegin(d);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (this.mMode == Mode.Drawing) {
            float x = event.getX();
            float y = event.getY();
            switch (event.getAction()) {
                case 0: {
                    this.touch_start(x, y);
                    break;
                }
                case 2: {
                    this.touch_move(x, y);
                    break;
                }
                case 1: {
                    this.touch_up();
                }
            }
        }
        if ((event.getAction() & event.getActionMasked()) == 0) {
            this.tapDisabled = false;
        }
        return super.onTouchEvent(event);
    }

    private void touch_start(float x, float y) {
        MuPDFView pageView = (MuPDFView)this.getDisplayedView();
        if (pageView != null) {
            pageView.startDraw(x, y);
        }
        this.mX = x;
        this.mY = y;
    }

    private void touch_move(float x, float y) {
        float dx = Math.abs(x - this.mX);
        float dy = Math.abs(y - this.mY);
        if (dx >= 2.0f || dy >= 2.0f) {
            MuPDFView pageView = (MuPDFView)this.getDisplayedView();
            if (pageView != null) {
                pageView.continueDraw(x, y);
            }
            this.mX = x;
            this.mY = y;
        }
    }

    private void touch_up() {
    }

    @Override
    protected void onChildSetup(int i, View v) {
        if (SearchTaskResult.get() != null && SearchTaskResult.get().pageNumber == i) {
            ((MuPDFView)v).setSearchBoxes(SearchTaskResult.get().searchBoxes);
        } else {
            ((MuPDFView)v).setSearchBoxes(null);
        }
        ((MuPDFView)v).setLinkHighlighting(this.mLinksEnabled);
        ((MuPDFView)v).setChangeReporter(new Runnable(){

            @Override
            public void run() {
                MuPDFReaderView.this.applyToChildren(new ReaderView.ViewMapper(){

                    @Override
                    void applyToView(View view) {
                        ((MuPDFView)view).update();
                    }
                });
            }
        });
    }

    @Override
    protected void onMoveToChild(int i) {
        if (SearchTaskResult.get() != null && SearchTaskResult.get().pageNumber != i) {
            SearchTaskResult.set(null);
            this.resetupChildren();
        }
    }

    @Override
    protected void onMoveOffChild(int i) {
        View v = this.getView(i);
        if (v != null) {
            ((MuPDFView)v).deselectAnnotation();
        }
    }

    @Override
    protected void onSettle(View v) {
        ((MuPDFView)v).addHq(false);
    }

    @Override
    protected void onUnsettle(View v) {
        ((MuPDFView)v).removeHq();
    }

    @Override
    protected void onNotInUse(View v) {
        ((MuPDFView)v).releaseResources();
    }

    @Override
    protected void onScaleChild(View v, Float scale) {
        ((MuPDFView)v).setScale(scale.floatValue());
    }

    static enum Mode {
        Viewing,
        Selecting,
        Drawing;

    }
}

