/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import java.util.ArrayList;
import java.util.List;

public class TextDrawer {
    private Canvas mTextCanvas;
    private Bitmap mTextBitmap;
    private String mText;
    private List<String> mBreakLabels = new ArrayList<String>();
    private Paint mPaint = new Paint();
    private int mAvailableWidth;
    private int mMeasureHeight = 0;
    private float mLineSpace = 0.0f;
    private int mHorizontalAlign = 3;

    public TextDrawer(Context context) {
        this.mPaint.setAntiAlias(true);
        float defaultTextSize = TypedValue.applyDimension((int)2, (float)16.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.mPaint.setTextSize(defaultTextSize);
    }

    public TextDrawer text(String text) {
        this.mText = text;
        return this;
    }

    public TextDrawer textSize(float size) {
        if (size > 0.0f) {
            this.mPaint.setTextSize(size);
        }
        return this;
    }

    public TextDrawer textColor(int color2) {
        this.mPaint.setColor(color2);
        return this;
    }

    public TextDrawer availableWidth(int width) {
        this.mAvailableWidth = width;
        return this;
    }

    public TextDrawer align(int gravity) {
        this.mHorizontalAlign = gravity;
        return this;
    }

    public int getTextWidth() {
        if (this.mBreakLabels.size() > 0) {
            return (int)this.mPaint.measureText(this.mBreakLabels.get(0));
        }
        return 0;
    }

    public int getMeasureHeight() {
        return this.mMeasureHeight;
    }

    public void measure() {
        if (!TextUtils.isEmpty((CharSequence)this.mText)) {
            this.breakLabel(this.mText);
            this.mTextBitmap = Bitmap.createBitmap((int)Math.max(this.mAvailableWidth, this.getTextWidth()), (int)this.mMeasureHeight, (Bitmap.Config)Bitmap.Config.ARGB_4444);
            this.mTextCanvas = new Canvas(this.mTextBitmap);
        }
    }

    public boolean isBreaked() {
        return this.mPaint.measureText(this.mText) > (float)this.mAvailableWidth;
    }

    private void breakLabel(String label) {
        int index = this.mPaint.breakText(label, true, (float)this.mAvailableWidth, null);
        if (index <= label.length()) {
            String lineLabel = label.substring(0, index);
            this.mBreakLabels.add(lineLabel);
            this.mMeasureHeight = (int)((float)this.mMeasureHeight + ((float)this.getTextHeight() + this.mLineSpace));
            String residualLabel = label.substring(index, label.length());
            if (!TextUtils.isEmpty((CharSequence)residualLabel)) {
                this.breakLabel(residualLabel);
            } else {
                this.mMeasureHeight = (int)((float)this.mMeasureHeight - this.mLineSpace);
            }
        }
    }

    private int getTextHeight() {
        Paint.FontMetrics fontMetrics = this.mPaint.getFontMetrics();
        return (int)(fontMetrics.bottom + Math.abs(fontMetrics.top));
    }

    public Bitmap draw() {
        if (this.mBreakLabels.size() > 0) {
            float y = (float)this.getTextHeight() - this.mPaint.getFontMetrics().bottom;
            for (String label : this.mBreakLabels) {
                int x2 = this.mHorizontalAlign == 3 ? 0 : Math.max(this.mAvailableWidth, this.getTextWidth()) - (int)this.mPaint.measureText(label);
                this.mTextCanvas.drawText(label, (float)x2, y, this.mPaint);
                y += (float)this.getTextHeight() + this.mLineSpace;
            }
        }
        return this.mTextBitmap;
    }
}

