/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import com.szboanda.android.platform.view.IPinnedHeaderListItem;
import com.szboanda.android.platform.view.XListView;

public class PinnedHeaderListView
extends XListView {
    private static final int MAX_ALPHA = 255;
    private PinnedHeaderAdapter mAdapter;
    private View mHeaderView;
    private boolean mHeaderViewVisible;
    private int mHeaderViewWidth;
    private int mHeaderViewHeight;

    public PinnedHeaderListView(Context context) {
        super(context);
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public PinnedHeaderListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setPinnedHeaderView(View view) {
        this.mHeaderView = view;
        if (this.mHeaderView != null) {
            this.setFadingEdgeLength(0);
        }
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        this.mAdapter = (PinnedHeaderAdapter)adapter;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mHeaderView != null) {
            this.measureChild(this.mHeaderView, widthMeasureSpec, heightMeasureSpec);
            this.mHeaderViewWidth = this.mHeaderView.getMeasuredWidth();
            this.mHeaderViewHeight = this.mHeaderView.getMeasuredHeight();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mHeaderView != null) {
            this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
            this.layoutHeaderView(this.getFirstVisiblePosition());
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mHeaderViewVisible && this.mHeaderView != null) {
            this.drawChild(canvas, this.mHeaderView, this.getDrawingTime());
        }
    }

    public void layoutHeaderView(int firstVisableItemPosition) {
        if (this.mHeaderView == null) {
            return;
        }
        int state = this.mAdapter.getPinnedHeaderState(firstVisableItemPosition);
        switch (state) {
            case 0: {
                this.mHeaderViewVisible = false;
                break;
            }
            case 1: {
                this.mAdapter.refreshHeaderView(this.mHeaderView, firstVisableItemPosition, 255);
                if (this.mHeaderView.getTop() != 0) {
                    this.mHeaderView.layout(0, 0, this.mHeaderViewWidth, this.mHeaderViewHeight);
                }
                this.mHeaderViewVisible = true;
                break;
            }
            case 2: {
                int alpha;
                int y;
                View firstView = this.getChildAt(0);
                int bottom = firstView.getBottom();
                int headerHeight = this.mHeaderView.getHeight();
                if (bottom < headerHeight) {
                    y = bottom - headerHeight;
                    alpha = 255 * (headerHeight + y) / headerHeight;
                } else {
                    y = 0;
                    alpha = 255;
                }
                IPinnedHeaderListItem firstItem = (IPinnedHeaderListItem)((BaseAdapter)this.mAdapter).getItem(firstVisableItemPosition);
                if (!firstItem.isGroupItem()) {
                    this.mAdapter.refreshHeaderView(this.mHeaderView, firstVisableItemPosition, alpha);
                }
                if (this.mHeaderView.getTop() != y) {
                    this.mHeaderView.layout(0, y, this.mHeaderViewWidth, this.mHeaderViewHeight + y);
                }
                this.mHeaderViewVisible = true;
                break;
            }
        }
    }

    public static interface PinnedHeaderAdapter {
        public static final int PINNED_HEADER_GONE = 0;
        public static final int PINNED_HEADER_VISIBLE = 1;
        public static final int PINNED_HEADER_PUSHED_UP = 2;

        public int getPinnedHeaderState(int var1);

        public void refreshHeaderView(View var1, int var2, int var3);
    }
}

