/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.szboanda.android.platform.util.BitmapUtils;
import com.szboanda.android.platform.util.DimensionUtils;

public class LinearLayoutWithTitle
extends LinearLayout
implements View.OnClickListener {
    private ImageView imageLeftIndicator;
    private ImageView imageRightIndicator;
    private TextView txtTitle;
    private int defaultIndicatorDimens;
    private LinearLayout mChildsParent;
    private boolean isChildsParentIndent = true;
    private boolean isCollapseable = true;
    private boolean isExpanded = true;
    RelativeLayout titleContainer = null;
    Bitmap indicatorExpanded = null;
    Bitmap indicatorCollapseed = null;
    Bitmap dot = null;
    Paint mPaint = null;

    public LinearLayoutWithTitle(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LinearLayoutWithTitle(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.defaultIndicatorDimens = DimensionUtils.dip2Px(this.getContext(), 26);
        this.setWillNotDraw(false);
        this.setOrientation(1);
        this.initDrawMaterial();
        this.initTitle();
        this.initContentParent();
    }

    private void initTitle() {
        int titleHeight = DimensionUtils.dip2Px(this.getContext(), 42);
        this.titleContainer = new RelativeLayout(this.getContext());
        LinearLayout.LayoutParams lp1 = new LinearLayout.LayoutParams(-1, titleHeight);
        this.titleContainer.setLayoutParams((ViewGroup.LayoutParams)lp1);
        int padding = DimensionUtils.dip2Px(this.getContext(), 5);
        this.titleContainer.setPadding(0, 0, padding, 0);
        this.titleContainer.setOnClickListener((View.OnClickListener)(this.isCollapseable ? this : null));
        this.addView((View)this.titleContainer);
        int leftIndicatorId = 1;
        this.imageLeftIndicator = new ImageView(this.getContext());
        this.imageLeftIndicator.setId(leftIndicatorId);
        this.imageLeftIndicator.setScaleType(ImageView.ScaleType.FIT_CENTER);
        RelativeLayout.LayoutParams lp2 = new RelativeLayout.LayoutParams(this.defaultIndicatorDimens, this.defaultIndicatorDimens);
        lp2.addRule(15);
        this.imageLeftIndicator.setLayoutParams((ViewGroup.LayoutParams)lp2);
        this.titleContainer.addView((View)this.imageLeftIndicator);
        this.drawDot();
        this.imageLeftIndicator.setImageBitmap(this.dot);
        int titleId = 2;
        this.txtTitle = new TextView(this.getContext());
        this.txtTitle.setId(titleId);
        this.txtTitle.setTextSize(18.0f);
        this.txtTitle.setTextColor(-13282898);
        this.txtTitle.setTypeface(Typeface.DEFAULT_BOLD);
        RelativeLayout.LayoutParams lp3 = new RelativeLayout.LayoutParams(-1, -1);
        lp3.addRule(1, 1);
        lp3.addRule(0, 3);
        this.txtTitle.setGravity(16);
        this.txtTitle.setLayoutParams((ViewGroup.LayoutParams)lp3);
        this.titleContainer.addView((View)this.txtTitle);
        int rightIndicatorId = 3;
        this.imageRightIndicator = new ImageView(this.getContext());
        this.imageRightIndicator.setId(rightIndicatorId);
        RelativeLayout.LayoutParams lp4 = new RelativeLayout.LayoutParams(-2, -2);
        lp4.addRule(15);
        lp4.addRule(11);
        lp4.rightMargin = DimensionUtils.dip2Px(this.getContext(), 8);
        this.imageRightIndicator.setLayoutParams((ViewGroup.LayoutParams)lp4);
        this.imageRightIndicator.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.titleContainer.addView((View)this.imageRightIndicator);
        this.setRightIndicator(this.isExpanded);
    }

    public void setCollapseable(boolean collapseable) {
        this.isCollapseable = collapseable;
    }

    private void initContentParent() {
        this.mChildsParent = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        this.mChildsParent.setLayoutParams((ViewGroup.LayoutParams)lp);
        this.mChildsParent.setOrientation(1);
        this.addView((View)this.mChildsParent);
    }

    public void addChild(View child) {
        this.mChildsParent.addView(child);
    }

    public void removeAllChilds() {
        this.mChildsParent.removeAllViews();
    }

    public void setTitle(String title) {
        this.txtTitle.setText((CharSequence)title);
    }

    public void setTitleColor(int color) {
        this.txtTitle.setTextColor(color);
    }

    public TextView getTitleView() {
        return this.txtTitle;
    }

    public ImageView getLeftIndicator() {
        return this.imageLeftIndicator;
    }

    public ImageView getRightIndicator() {
        return this.imageRightIndicator;
    }

    public View getChildsParent() {
        return this.mChildsParent;
    }

    public RelativeLayout getTitleContainer() {
        return this.titleContainer;
    }

    public void collapseChilds() {
        if (this.isExpanded) {
            this.isExpanded = false;
            this.mChildsParent.setVisibility(this.isExpanded ? 0 : 8);
            this.setRightIndicator(this.isExpanded);
        }
    }

    public void expandChilds() {
        if (!this.isExpanded) {
            this.isExpanded = true;
            this.mChildsParent.setVisibility(this.isExpanded ? 0 : 8);
            this.setRightIndicator(this.isExpanded);
        }
    }

    public void setChildsParentIndent(boolean indent) {
        this.isChildsParentIndent = indent;
    }

    public void setTitleContainerHeight(int height) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.titleContainer.getLayoutParams();
        layoutParams.height = DimensionUtils.dip2Px(this.getContext(), height);
        this.titleContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void setTitleLeftMargin(int margin) {
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.txtTitle.getLayoutParams();
        lp.leftMargin = margin;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.isExpanded && this.mChildsParent != null) {
            int indentWidth = this.imageLeftIndicator.getMeasuredWidth() / (this.isChildsParentIndent ? 1 : 2);
            this.measureChild((View)this.mChildsParent, widthMeasureSpec - indentWidth, heightMeasureSpec);
            int titleHeight = this.txtTitle.getMeasuredHeight();
            int contentHeight = this.mChildsParent.getMeasuredHeight();
            this.setMeasuredDimension(this.getMeasuredWidth(), titleHeight + contentHeight + this.getPaddingTop() + this.getPaddingBottom());
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (this.isExpanded && this.mChildsParent != null) {
            int left = this.isChildsParentIndent ? (int)this.txtTitle.getX() : this.imageLeftIndicator.getMeasuredWidth() / 2;
            this.mChildsParent.layout(left, this.txtTitle.getHeight(), r, this.txtTitle.getHeight() + this.mChildsParent.getMeasuredHeight());
        }
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.isExpanded && this.mChildsParent.getChildCount() > 0) {
            this.drawDivideLine(canvas);
        }
    }

    public void setRightIndicatorVisable(boolean isVisable) {
        this.imageRightIndicator.setVisibility(isVisable || this.isCollapseable ? 0 : 8);
    }

    private void initDrawMaterial() {
        this.dot = Bitmap.createBitmap((int)this.defaultIndicatorDimens, (int)this.defaultIndicatorDimens, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.dot.eraseColor(0);
        this.mPaint = new Paint();
        this.mPaint.setStyle(Paint.Style.FILL);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(-1996554240);
    }

    private void drawDivideLine(Canvas canvas) {
        this.mPaint.setColor(-3355444);
        this.mPaint.setStrokeWidth(3.0f);
        canvas.drawLine(this.txtTitle.getX(), (float)(this.txtTitle.getHeight() - 1), (float)this.getWidth(), (float)(this.txtTitle.getHeight() - 1), this.mPaint);
    }

    private void drawDot() {
        Canvas c = new Canvas(this.dot);
        int radius = this.defaultIndicatorDimens / 2;
        c.drawCircle((float)radius, (float)radius, (float)(radius / 2), this.mPaint);
    }

    public void onClick(View v) {
        if (this.isCollapseable && this.mChildsParent.getChildCount() > 0) {
            this.isExpanded = !this.isExpanded;
            this.mChildsParent.setVisibility(this.isExpanded ? 0 : 8);
            this.setRightIndicator(this.isExpanded);
        }
    }

    public void setRightIndicator(boolean expanded) {
        if (this.isCollapseable) {
            if (this.indicatorExpanded == null) {
                this.indicatorExpanded = BitmapUtils.drawArrow(this.getContext(), DimensionUtils.dip2Px(this.getContext(), 20), -7829368, BitmapUtils.ArrowDirection.TOP);
                this.indicatorCollapseed = BitmapUtils.drawArrow(this.getContext(), DimensionUtils.dip2Px(this.getContext(), 20), -7829368, BitmapUtils.ArrowDirection.BOTTOM);
            }
            this.imageRightIndicator.setImageBitmap(this.isExpanded ? this.indicatorExpanded : this.indicatorCollapseed);
        }
    }

    public void setRightIndicator(Bitmap indicator) {
        this.imageRightIndicator.setImageBitmap(indicator);
    }
}

