/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.view.View;
import com.szboanda.android.platform.view.TextDrawer;

public class LabelDrawer {
    private static final int DEFAULT_LABEL_COLOR = -10066330;
    private View mTargetView;
    private String mLabelText;
    private float mLabelTextSize;
    private int mLabelTextColor = -10066330;
    private int mOriginalPaddingLeft = 0;
    private int mOriginalPaddingTop = 0;
    private int mOriginalPaddingRight = 0;
    private int mOriginalPaddingBottom = 0;
    private int mAdjustPadding = 0;
    private boolean isHorizontalAlignRight = false;
    private boolean isLabelAlignVerticalCenter = true;
    private int mLabelWeight = 100;
    private int mLabelMargin = 0;
    boolean hasMeasureLabel;
    private int mLabelOrientation;
    private TextDrawer mTextDrawer;
    private boolean mBreakAllow = true;
    private int mMeasureHeight = 0;
    Context mContext;

    public LabelDrawer() {
        this.init();
    }

    public LabelDrawer(Context context) {
        this.mContext = context;
        this.init();
    }

    public LabelDrawer(String label) {
        this.mLabelText = label;
        this.init();
    }

    private void init() {
    }

    public LabelDrawer setLabel(String label) {
        this.mLabelText = label;
        return this;
    }

    public String getLabel() {
        return this.mLabelText;
    }

    public LabelDrawer setLabelSize(float size) {
        this.mLabelTextSize = size;
        return this;
    }

    public LabelDrawer setLableTextColor(int color) {
        this.mLabelTextColor = color;
        return this;
    }

    public int getLableTextColor() {
        return this.mLabelTextColor;
    }

    public LabelDrawer setLabelWeight(int labelWeight) {
        this.mLabelWeight = labelWeight > 50 ? 50 : labelWeight;
        return this;
    }

    @Deprecated
    public LabelDrawer setLabelPaddingLeft(int padding) {
        return this;
    }

    public LabelDrawer setLabelMarginRight(int margin) {
        this.mLabelMargin = margin;
        return this;
    }

    public LabelDrawer setHorizontalAlignRight(boolean isHorizontalAlignRight) {
        this.isHorizontalAlignRight = isHorizontalAlignRight;
        return this;
    }

    public LabelDrawer setLabelAlignVerticalCenter(boolean isLabelAlignVerticalCenter) {
        this.isLabelAlignVerticalCenter = isLabelAlignVerticalCenter;
        return this;
    }

    public LabelDrawer breakAllow(boolean allow) {
        this.mBreakAllow = allow;
        return this;
    }

    public int getAdjustedPadding() {
        return this.mAdjustPadding;
    }

    public int getOriginalPaddingLeft() {
        return this.mOriginalPaddingLeft;
    }

    public int getOriginalPaddingTop() {
        return this.mOriginalPaddingTop;
    }

    public float getLabelTextSize() {
        return this.mLabelTextSize;
    }

    public int getLabelHeight() {
        return this.mTextDrawer.getMeasureHeight();
    }

    public int getLabelOrientation() {
        return this.mLabelOrientation;
    }

    public int getLabelMargin() {
        return this.mLabelMargin;
    }

    public int measureLabel(View view, int measureWidth, int measureHeight) {
        if (!this.hasMeasureLabel) {
            this.mTargetView = view;
            this.mOriginalPaddingLeft = view.getPaddingLeft();
            this.mOriginalPaddingTop = view.getPaddingTop();
            this.mOriginalPaddingRight = view.getPaddingRight();
            this.mOriginalPaddingBottom = view.getPaddingBottom();
            this.mTextDrawer = new TextDrawer(view.getContext()).text(this.mLabelText).textSize(this.mLabelTextSize).textColor(this.mLabelTextColor).align(this.isHorizontalAlignRight ? 5 : 3).availableWidth(this.caculateAvailableWidth(measureWidth));
            if (this.mBreakAllow) {
                this.mLabelOrientation = 0;
            } else if (this.mTextDrawer.isBreaked()) {
                this.mLabelWeight = 100;
                this.mTextDrawer.availableWidth(this.caculateAvailableWidth(measureWidth)).align(3);
                this.mLabelOrientation = 1;
            } else {
                this.mLabelOrientation = 0;
            }
            this.mTextDrawer.measure();
            this.resetPadding(view);
            this.hasMeasureLabel = true;
            this.mMeasureHeight = 0 == this.mLabelOrientation ? this.mTextDrawer.getMeasureHeight() + this.mOriginalPaddingTop + this.mOriginalPaddingBottom : this.mTextDrawer.getMeasureHeight() + measureHeight;
        }
        return Math.max(measureHeight, this.mMeasureHeight);
    }

    private int caculateAvailableWidth(int measureWidth) {
        return measureWidth * this.mLabelWeight / 100 - this.mOriginalPaddingLeft - this.mOriginalPaddingRight - this.mLabelMargin;
    }

    private void resetPadding(View view) {
        if (0 == this.mLabelOrientation) {
            int p = view.getMeasuredWidth() * this.mLabelWeight / 100;
            view.setPadding(p, this.mOriginalPaddingTop, this.mOriginalPaddingRight, this.mOriginalPaddingBottom);
            this.mAdjustPadding = view.getPaddingLeft();
        } else {
            view.setPadding(this.mOriginalPaddingLeft, this.mOriginalPaddingTop + this.mTextDrawer.getMeasureHeight() + this.mLabelMargin, this.mOriginalPaddingRight, this.mOriginalPaddingBottom);
            this.mAdjustPadding = view.getPaddingTop();
        }
    }

    public void drawLabel(Canvas canvas) {
        canvas.save();
        Bitmap textBitmap = this.mTextDrawer.draw();
        if (textBitmap != null) {
            if (0 == this.mLabelOrientation) {
                if (this.isLabelAlignVerticalCenter) {
                    canvas.translate((float)this.mOriginalPaddingLeft, (float)(this.mTargetView.getMeasuredHeight() / 2 - this.mTextDrawer.getMeasureHeight() / 2));
                    canvas.drawBitmap(textBitmap, 0.0f, 0.0f, null);
                    canvas.restore();
                } else {
                    canvas.drawBitmap(textBitmap, (float)this.mOriginalPaddingLeft, (float)this.mOriginalPaddingTop, null);
                }
            } else {
                canvas.drawBitmap(textBitmap, (float)this.mOriginalPaddingLeft, (float)this.mOriginalPaddingTop, null);
            }
        }
    }
}

