/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.text.Html;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.szboanda.android.platform.view.BindableViewHandler;
import com.szboanda.android.platform.view.IBindableView;

public class BindableTextView
extends TextView
implements IBindableView {
    private BindableViewHandler mBindHandler = new BindableViewHandler(this);

    public BindableTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mBindHandler.initWithTypedArray(this.getResources(), attrs);
    }

    public BindableTextView(Context context) {
        super(context);
    }

    @Override
    public void setField(String fieldName) {
        this.mBindHandler.setField(fieldName);
    }

    @Override
    public void setEmptyMsg(String notEmptyTipMsg) {
        this.mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
    }

    @Override
    public void setBindValue(String value) {
        Object v = !TextUtils.isEmpty((CharSequence)value) ? (value.replace("\\t", "").replace("\n", "").matches(".*<.+>.*</[a-zA-Z0-9]+>.*") ? Html.fromHtml((String)value) : (value.matches("^[1-9]{1}[0-9]{3}-[0-9]{1,2}-[0-9]{1,2}\\s00:00$") ? value.split(" ")[0] : value)) : "";
        this.setText((CharSequence)v);
    }

    @Override
    public String getBindValue() {
        return this.getText().toString();
    }

    @Override
    public BindableViewHandler getBindHandler() {
        return this.mBindHandler;
    }
}

