/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.CheckBox;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.view.BindableViewHandler;
import com.szboanda.android.platform.view.IBindableView;
import java.util.Arrays;

public class BindableCheckBox
extends CheckBox
implements IBindableView {
    private String checkedValue;
    private BindableViewHandler mBindHandler = new BindableViewHandler(this);

    public BindableCheckBox(Context context) {
        super(context);
    }

    public BindableCheckBox(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mBindHandler.initWithTypedArray(this.getResources(), attrs);
        TypedArray ta = this.getResources().obtainAttributes(attrs, R.styleable.BindableCheckBox);
        this.checkedValue = ta.getString(R.styleable.BindableCheckBox_checkedValue);
        if (TextUtils.isEmpty((CharSequence)this.checkedValue)) {
            this.checkedValue = this.getText().toString();
        }
        ta.recycle();
    }

    public void setDefaultValue(String checkedValue) {
        this.checkedValue = checkedValue;
    }

    @Override
    public void setField(String field) {
        this.mBindHandler.setField(field);
    }

    @Override
    public void setEmptyMsg(String notEmptyTipMsg) {
        this.mBindHandler.setNotEmptyMsg(notEmptyTipMsg);
    }

    @Override
    public void setBindValue(String value) {
        if (TextUtils.isEmpty((CharSequence)value)) {
            this.setChecked(false);
        } else {
            boolean hasCheckValue = Arrays.asList(value.split(this.mBindHandler.getMultiValueSeparator())).contains(this.checkedValue);
            this.setChecked(hasCheckValue);
        }
    }

    @Override
    public String getBindValue() {
        return this.isChecked() ? this.checkedValue : "";
    }

    @Override
    public BindableViewHandler getBindHandler() {
        return this.mBindHandler;
    }
}

