/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.content.Context;
import android.util.DisplayMetrics;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ResourceUtils {
    public static int findResId(Context context, String namePrefix, ResoureType type) {
        List<Integer> ids = ResourceUtils.findResIdsByNamePrefix(context, namePrefix, type);
        if (ids.size() > 0) {
            return ids.get(0);
        }
        return 0;
    }

    public static List<Integer> findResIdsByNamePrefix(Context context, String namePrefix, ResoureType type) {
        String packageName = context.getPackageName();
        String typeStr = type.toString().toLowerCase(Locale.getDefault());
        ArrayList<Integer> ids = new ArrayList<Integer>();
        try {
            Field[] fields;
            Class<?> typeCls = Class.forName(packageName + ".R$" + typeStr);
            for (Field f : fields = typeCls.getDeclaredFields()) {
                String name = f.getName();
                if (!name.startsWith(namePrefix)) continue;
                ids.add(ResourceUtils.getResourcesId(context, type, name));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ids;
    }

    public static int getResourcesId(Context context, ResoureType type, String name) {
        return context.getResources().getIdentifier(name, type.toString().toLowerCase(Locale.getDefault()), context.getPackageName());
    }

    public static final int[] getStyleableIntArray(Context context, String name) {
        try {
            Field[] fields2;
            for (Field f : fields2 = Class.forName(context.getPackageName() + ".R$styleable").getFields()) {
                if (!f.getName().equals(name)) continue;
                int[] ret = (int[])f.get(null);
                return ret;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static final int getStyleableInt(Context context, String name) {
        try {
            Field[] fields2;
            for (Field f : fields2 = Class.forName(context.getPackageName() + ".R$styleable").getFields()) {
                if (!f.getName().equals(name)) continue;
                int ret = (Integer)f.get(null);
                return ret;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1;
    }

    public static float getScaledDensity(float source, Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        float value = dm.scaledDensity;
        return source / value;
    }

    public static enum ResoureType {
        ID,
        STRING,
        LAYOUT,
        DRAWABLE,
        STYLE,
        COLOR,
        DIMEN,
        INTEGER,
        ARRAY;

    }
}

