/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class AppInfoHelper {
    private static final String TAG = "AppInfoHelper.java";

    public static int getVersionCode(Context context) {
        return AppInfoHelper.getVersionCode(context, null);
    }

    public static int getVersionCode(Context context, String packageName) {
        int versionCode = 1;
        String targetPackage = TextUtils.isEmpty((CharSequence)packageName) ? context.getPackageName() : packageName;
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(targetPackage, 0);
            versionCode = pi.versionCode;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionCode;
    }

    public static String getVersionName(Context context) {
        String versionName = "1.0";
        try {
            PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            versionName = pi.versionName;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return versionName;
    }

    public static String[] getAppInfo(Context context, String appName) {
        String[] result = null;
        PackageManager pg = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        List lists = pg.queryIntentActivities(intent, 0);
        for (ResolveInfo r : lists) {
            ActivityInfo activityInfo = r.activityInfo;
            ApplicationInfo appInfo = activityInfo.applicationInfo;
            String tempAppName = pg.getApplicationLabel(appInfo).toString();
            if (!tempAppName.equals(appName)) continue;
            result = new String[]{activityInfo.packageName, activityInfo.name};
            break;
        }
        return result;
    }

    public static String getLauncherActivity(Context context, String packageName) {
        String result = null;
        PackageManager pg = context.getPackageManager();
        Intent intent = new Intent();
        intent.setAction("android.intent.action.MAIN");
        intent.addCategory("android.intent.category.LAUNCHER");
        List lists = pg.queryIntentActivities(intent, 0);
        for (ResolveInfo r : lists) {
            ActivityInfo activityInfo = r.activityInfo;
            if (!packageName.equals(activityInfo.packageName)) continue;
            result = activityInfo.name;
            break;
        }
        return result;
    }

    public static void addAppShortcut(Activity launchActivity) {
        PackageManager pm = launchActivity.getPackageManager();
        try {
            ApplicationInfo appInfo = pm.getApplicationInfo(launchActivity.getPackageName(), 0);
            String appName = pm.getApplicationLabel(appInfo).toString();
            if (!AppInfoHelper.hasShortcut((Context)launchActivity, appName)) {
                Intent shortcutIntent = new Intent("com.android.launcher.action.INSTALL_SHORTCUT");
                shortcutIntent.putExtra("android.intent.extra.shortcut.NAME", appName);
                shortcutIntent.putExtra("duplicate", false);
                Intent mainIntent = new Intent("android.intent.action.MAIN");
                mainIntent.addCategory("android.intent.category.LAUNCHER");
                mainIntent.setClass((Context)launchActivity, launchActivity.getClass());
                shortcutIntent.putExtra("android.intent.extra.shortcut.INTENT", (Parcelable)mainIntent);
                Intent.ShortcutIconResource shortcutIcon = Intent.ShortcutIconResource.fromContext((Context)launchActivity, (int)appInfo.icon);
                shortcutIntent.putExtra("android.intent.extra.shortcut.ICON_RESOURCE", (Parcelable)shortcutIcon);
                launchActivity.sendBroadcast(shortcutIntent);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean hasShortcut(Context context, String appName) {
        boolean result;
        block4: {
            result = false;
            Cursor cursor = null;
            ProviderInfo pi = null;
            try {
                pi = AppInfoHelper.queryLauncherContentProvider(context);
                if (pi != null) {
                    String authority = pi.authority;
                    String uri = "content://" + authority + "/favorites?notify=true";
                    ContentResolver resolver = context.getContentResolver();
                    cursor = resolver.query(Uri.parse((String)uri), null, "title=? ", new String[]{appName}, null);
                    if (cursor != null && cursor.getCount() > 0) {
                        result = true;
                        cursor.close();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = true;
                Log.i((String)TAG, (String)("\u9700\u8981\u6dfb\u52a0\u7684\u6743\u9650\uff1a" + pi.readPermission));
                Log.i((String)TAG, (String)("\u9700\u8981\u6dfb\u52a0\u7684\u6743\u9650\uff1a" + pi.writePermission));
                if (cursor == null) break block4;
                cursor.close();
            }
        }
        return result;
    }

    private static ProviderInfo queryLauncherContentProvider(Context context) {
        PackageManager pm = context.getPackageManager();
        List providerInfos = pm.queryContentProviders(null, 0, 0);
        String launcherReadPermissionSuffix = ".launcher.permission.READ_SETTINGS";
        String launcherWritePermissionSuffix = ".launcher.permission.WRITE_SETTINGS";
        ProviderInfo result = null;
        if (providerInfos != null && providerInfos.size() > 0) {
            for (ProviderInfo pi : providerInfos) {
                String readPermission = pi.readPermission;
                String writePermission = pi.writePermission;
                if (readPermission == null || writePermission == null || !readPermission.endsWith(launcherReadPermissionSuffix) || !writePermission.endsWith(launcherWritePermissionSuffix)) continue;
                result = pi;
                break;
            }
        }
        return result;
    }

    public static boolean isAppAvailable(Context context, String packageName, String activityName) {
        PackageManager packageManager = context.getPackageManager();
        Intent intent = new Intent();
        intent.setClassName(packageName, activityName);
        List resolveInfo = packageManager.queryIntentActivities(intent, 64);
        return resolveInfo != null && resolveInfo.size() > 0;
    }

    public static boolean isAppAvailable(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo pi = null;
        try {
            pi = packageManager.getPackageInfo(packageName, 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pi != null;
    }

    public static String getUnInstalledApkSignature(String apkPath) {
        String PATH_PackageParser = "android.content.pm.PackageParser";
        try {
            Class<?> pkgParserCls = Class.forName(PATH_PackageParser);
            Constructor<?> pkgParserCt = pkgParserCls.getConstructor(new Class[0]);
            Object pkgParser = pkgParserCt.newInstance(new Object[0]);
            Class[] typeArgs = new Class[]{File.class, Integer.TYPE};
            Method pkgParser_parsePackageMtd = pkgParserCls.getDeclaredMethod("parsePackage", typeArgs);
            Object[] valueArgs = new Object[]{new File(apkPath), 64};
            Object pkgParserPkg = pkgParser_parsePackageMtd.invoke(pkgParser, valueArgs);
            typeArgs[0] = pkgParserPkg.getClass();
            typeArgs[1] = Integer.TYPE;
            Method pkgParser_collectCertificatesMtd = pkgParserCls.getDeclaredMethod("collectCertificates", typeArgs);
            valueArgs = new Object[]{pkgParserPkg, 64};
            pkgParser_collectCertificatesMtd.invoke(pkgParser, valueArgs);
            Field packageInfoFld = pkgParserPkg.getClass().getDeclaredField("mSignatures");
            Signature[] info = (Signature[])packageInfoFld.get(pkgParserPkg);
            return info[0].toCharsString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getInstalledApkSignature(Context context, String packageName) {
        PackageManager pm = context.getPackageManager();
        List apps = pm.getInstalledPackages(64);
        for (PackageInfo packageinfo : apps) {
            String thisName = packageinfo.packageName;
            if (!thisName.equals(packageName)) continue;
            return packageinfo.signatures[0].toCharsString();
        }
        return "";
    }

    public static String getApkSourcePath(Context context, String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return null;
        }
        try {
            ApplicationInfo appInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
            return appInfo.sourceDir;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

