/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.http;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.szboanda.android.platform.dialog.CustomProgressDialog;
import com.szboanda.android.platform.http.ErrorResolverFactory;
import com.szboanda.android.platform.http.IDataProtocol;
import com.szboanda.android.platform.http.IErroResolver;
import com.szboanda.android.platform.http.impl.ArrayProtocol;
import com.szboanda.android.platform.http.impl.EntityProtocol;
import com.szboanda.android.platform.http.impl.GroupProtocol;
import com.szboanda.android.platform.http.impl.JsonProtocol;
import com.szboanda.android.platform.util.JsonUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xutils.common.Callback;

public abstract class ResponseProcessor<T>
implements Callback.CommonCallback<String> {
    private Context mContext;
    private CustomProgressDialog mDialog = null;

    public Context getContext() {
        return this.mContext;
    }

    public void setContext(Context context) {
        this.mContext = context;
    }

    public void setDialog(CustomProgressDialog mDialog) {
        this.mDialog = mDialog;
    }

    public void setProgressDialog(CustomProgressDialog dialog) {
        this.mDialog = dialog;
    }

    public CustomProgressDialog getDialog() {
        return this.mDialog;
    }

    public String optKey() {
        return "";
    }

    public void onSuccess(String result) {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        Type type = this.getClass().getGenericSuperclass();
        Type[] typeArgs = ((ParameterizedType)type).getActualTypeArguments();
        Type convertType = null;
        IDataProtocol protocol = null;
        if (typeArgs[0] instanceof ParameterizedType) {
            Type[] listTypeArgs;
            ParameterizedType listParameterizedType = (ParameterizedType)typeArgs[0];
            if ((listParameterizedType.getRawType().equals(List.class) || listParameterizedType.getRawType().equals(ArrayList.class)) && (listTypeArgs = listParameterizedType.getActualTypeArguments())[0] instanceof Class) {
                convertType = listParameterizedType;
                protocol = new GroupProtocol();
            }
        } else {
            convertType = (Class)typeArgs[0];
            if (TextUtils.isEmpty((CharSequence)result)) {
                Log.i((String)convertType.getName(), (String)"\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            } else {
                Class typeCls = convertType;
                if (typeCls.equals(JSONObject.class)) {
                    protocol = new JsonProtocol();
                } else if (typeCls.equals(JSONArray.class)) {
                    protocol = new ArrayProtocol();
                } else if (!typeCls.equals(String.class)) {
                    protocol = new EntityProtocol();
                }
            }
        }
        if (!TextUtils.isEmpty((CharSequence)this.optKey())) {
            protocol.dataKey(this.optKey());
        }
        if (protocol != null && protocol instanceof GroupProtocol) {
            int totalCount;
            JSONObject json = JsonUtils.parseJsonObject(result);
            int n = totalCount = json != null ? json.optInt("total_count", -1) : -1;
            if (totalCount != -1) {
                this.onSuccessTyped(protocol != null ? protocol.convert(result, convertType) : result, totalCount);
            } else {
                this.onSuccessTyped(protocol != null ? protocol.convert(result, convertType) : result);
            }
        } else {
            this.onSuccessTyped(protocol != null ? protocol.convert(result, convertType) : result);
        }
    }

    public void onCancelled(Callback.CancelledException cex) {
    }

    public void onFinished() {
    }

    public void onError(Throwable ex, boolean isOnCallback) {
        if (this.mDialog != null) {
            this.mDialog.dismiss();
        }
        Log.e((String)"ResponseProcessor", (String)ex.getMessage());
        ex.printStackTrace();
        IErroResolver resolver = ErrorResolverFactory.newResolver(this.mContext, ex);
        if (resolver != null) {
            resolver.resolve();
        }
    }

    public abstract void onSuccessTyped(T var1);

    public void onSuccessTyped(T result, int totalCount) {
    }
}

