/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.dialog;

import android.content.Context;
import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.dialog.BaseDialog;
import com.szboanda.android.platform.util.DimensionUtils;

public class ViewDialog
extends BaseDialog {
    Button btnConfirm;
    Button btnCancel;
    Button btnReserve;
    LinearLayout linearBtnsContainer;
    LinearLayout linearRoot;
    LinearLayout linearContent;

    public ViewDialog(Context context) {
        this(context, -1);
    }

    public ViewDialog(Context context, int widthPercent) {
        super(context);
        this.initView(widthPercent);
    }

    public ViewDialog setTitle(String title) {
        if (!TextUtils.isEmpty((CharSequence)title) && null != this.titleView) {
            this.titleView.setText((CharSequence)title);
        }
        return this;
    }

    public ViewDialog setView(View view) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
        this.linearContent.addView(view, (ViewGroup.LayoutParams)lp);
        return this;
    }

    private void initView(int widthPercent) {
        this.linearRoot = new LinearLayout(this.getContext());
        LinearLayout.LayoutParams lpRoot = new LinearLayout.LayoutParams(-1, -2);
        this.linearRoot.setOrientation(1);
        this.linearRoot.setGravity(1);
        this.linearRoot.setLayoutParams((ViewGroup.LayoutParams)lpRoot);
        this.linearRoot.setBackgroundResource(R.drawable.viewjar_dialog_light_gray_frame);
        this.addTitleView();
        this.addContentViewContainer();
        this.addBottomBlock();
        int width = widthPercent != -1 ? DimensionUtils.getScreenWidth(this.getContext(), widthPercent) : DimensionUtils.getScreenWidth(this.getContext()) - 50;
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(width, -2);
        super.setContentView((View)this.linearRoot, (ViewGroup.LayoutParams)lp);
    }

    private void addTitleView() {
        this.titleView = new TextView(this.getContext());
        this.titleView.setText((CharSequence)"\u8bf7\u8f93\u5165\u67e5\u8be2\u4fe1\u606f");
        this.titleView.setGravity(16);
        this.titleView.setBackgroundResource(R.drawable.viewjar_dialog_title_light_gray_bg);
        this.titleView.setTextSize(20.0f);
        this.titleView.setTextColor(Color.parseColor((String)"#666666"));
        this.titleView.setShadowLayer(1.0f, 1.0f, 1.0f, Color.parseColor((String)"#999999"));
        this.linearRoot.addView((View)this.titleView);
    }

    private void addContentViewContainer() {
        this.linearContent = new LinearLayout(this.getContext());
        this.linearContent.setOrientation(1);
        LinearLayout.LayoutParams lpContent = new LinearLayout.LayoutParams(-1, -2);
        this.linearContent.setBackgroundColor(Color.parseColor((String)"#EBEBEB"));
        this.linearContent.setGravity(16);
        this.linearContent.setLayoutParams((ViewGroup.LayoutParams)lpContent);
        this.linearRoot.addView((View)this.linearContent);
    }

    private void addBottomBlock() {
        int margin;
        this.linearBtnsContainer = new LinearLayout(this.getContext());
        this.linearBtnsContainer.setOrientation(0);
        LinearLayout.LayoutParams lpBtnContainer = new LinearLayout.LayoutParams(-1, -2);
        this.linearBtnsContainer.setLayoutParams((ViewGroup.LayoutParams)lpBtnContainer);
        this.linearBtnsContainer.setBackgroundResource(R.drawable.viewjar_dialog_bottom_light_gray_bg);
        int lrPadding = DimensionUtils.dip2Px(this.getContext(), 10);
        int tbPadding = DimensionUtils.dip2Px(this.getContext(), 8);
        this.linearBtnsContainer.setPadding(lrPadding, tbPadding, lrPadding, tbPadding);
        this.linearBtnsContainer.setVisibility(8);
        this.linearRoot.addView((View)this.linearBtnsContainer);
        this.btnConfirm = new Button(this.getContext());
        this.btnConfirm.setText((CharSequence)"\u786e\u5b9a");
        this.btnConfirm.setTextSize(18.0f);
        this.btnConfirm.setTextColor(-1);
        this.btnConfirm.setBackgroundResource(R.drawable.viewjar_selector_sky_blue_btn);
        LinearLayout.LayoutParams lpConfirm = new LinearLayout.LayoutParams(-1, -2);
        lpConfirm.weight = 1.0f;
        lpConfirm.leftMargin = margin = DimensionUtils.dip2Px(this.getContext(), 5);
        lpConfirm.rightMargin = margin;
        this.btnConfirm.setLayoutParams((ViewGroup.LayoutParams)lpConfirm);
        this.btnConfirm.setVisibility(8);
        this.linearBtnsContainer.addView((View)this.btnConfirm);
        this.btnReserve = new Button(this.getContext());
        this.btnReserve.setText((CharSequence)"\u5907\u7528");
        this.btnReserve.setTextSize(18.0f);
        this.btnReserve.setTextColor(Color.parseColor((String)"#666666"));
        this.btnReserve.setBackgroundResource(R.drawable.viewjar_selector_light_gray_btn);
        LinearLayout.LayoutParams lpReserve = new LinearLayout.LayoutParams(-1, -2);
        lpReserve.weight = 1.0f;
        lpReserve.leftMargin = margin;
        lpReserve.rightMargin = margin;
        this.btnReserve.setLayoutParams((ViewGroup.LayoutParams)lpReserve);
        this.btnReserve.setVisibility(8);
        this.linearBtnsContainer.addView((View)this.btnReserve);
        this.btnCancel = new Button(this.getContext());
        this.btnCancel.setText((CharSequence)"\u53d6\u6d88");
        this.btnCancel.setTextSize(18.0f);
        this.btnCancel.setTextColor(Color.parseColor((String)"#666666"));
        this.btnCancel.setBackgroundResource(R.drawable.viewjar_selector_light_gray_btn);
        LinearLayout.LayoutParams lpCancle = new LinearLayout.LayoutParams(-1, -2);
        lpCancle.weight = 1.0f;
        lpCancle.leftMargin = margin;
        lpCancle.rightMargin = margin;
        this.btnCancel.setLayoutParams((ViewGroup.LayoutParams)lpCancle);
        this.btnCancel.setVisibility(8);
        this.linearBtnsContainer.addView((View)this.btnCancel);
    }

    public void setPadding(int padding) {
        this.linearContent.setPadding(padding, padding, padding, padding);
    }

    public void setPaddingBottom(int p) {
        this.linearContent.setPadding(this.linearContent.getPaddingLeft(), this.linearContent.getPaddingTop(), this.linearContent.getPaddingRight(), p);
    }

    public void setViewBg(int res) {
        this.linearContent.setBackgroundResource(res);
    }

    public LinearLayout getViewParent() {
        return this.linearContent;
    }

    public void setTitleBackground(int res) {
        try {
            if (this.titleView != null) {
                this.titleView.setBackgroundResource(res);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPositiveBtnText(CharSequence text) {
        if (this.btnConfirm != null && !TextUtils.isEmpty((CharSequence)text)) {
            this.btnConfirm.setText(text);
        }
    }

    public void setNegativeBtnText(CharSequence text) {
        if (this.btnCancel != null && !TextUtils.isEmpty((CharSequence)text)) {
            this.btnCancel.setText(text);
        }
    }

    public ViewDialog setPositiveButton(CharSequence text, BaseDialog.OnDialogButtonClickListener listener) {
        this.linearBtnsContainer.setVisibility(0);
        this.btnConfirm.setVisibility(0);
        this.btnConfirm.setTag((Object)listener);
        this.btnConfirm.setOnClickListener((View.OnClickListener)this.mListener);
        this.btnConfirm.setText(text);
        return this;
    }

    public ViewDialog setNegativeButton(CharSequence text, BaseDialog.OnDialogButtonClickListener listener) {
        this.linearBtnsContainer.setVisibility(0);
        this.btnCancel.setVisibility(0);
        this.btnCancel.setTag((Object)listener);
        this.btnCancel.setOnClickListener((View.OnClickListener)this.mListener);
        this.btnCancel.setText(text);
        return this;
    }

    public ViewDialog setNeutralButton(CharSequence text, BaseDialog.OnDialogButtonClickListener listener) {
        this.linearBtnsContainer.setVisibility(0);
        this.btnReserve.setText(text);
        this.btnReserve.setVisibility(0);
        this.btnReserve.setTag((Object)listener);
        this.btnReserve.setOnClickListener((View.OnClickListener)this.mListener);
        return this;
    }

    public void setContentView(int layoutResID) {
        View view = this.inflater.inflate(layoutResID, null);
        this.setContentView(view);
    }

    public ViewDialog setTitleInId(int textResID) {
        String text = this.context.getResources().getString(textResID);
        this.setTitle(text);
        return this;
    }

    public ViewDialog setView(int layoutResID) {
        this.setContentView(layoutResID);
        return this;
    }

    public ViewDialog setPositiveButton(int textId, BaseDialog.OnDialogButtonClickListener listener) {
        String text = this.context.getResources().getString(textId);
        this.setPositiveButton(text, listener);
        return this;
    }

    public ViewDialog setNegativeButton(int textId, BaseDialog.OnDialogButtonClickListener listener) {
        String text = this.context.getResources().getString(textId);
        this.setNegativeButton(text, listener);
        return this;
    }

    public ViewDialog setNeutralButton(int textId, BaseDialog.OnDialogButtonClickListener listener) {
        String text = this.context.getResources().getString(textId);
        this.setNeutralButton(text, listener);
        return this;
    }
}

