/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.dialog;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.widget.RemoteViews;
import com.szboanda.android.platform.R;
import com.szboanda.android.platform.activity.PdfViewActivity;
import com.szboanda.android.platform.util.FileUtils;

public class PercentNotification {
    private NotificationManager mNoticeManager;
    private Notification mNotice;
    private Context mContext;
    private RemoteViews rv = null;
    private long mTotal = 0L;

    public PercentNotification(Context context) {
        this.mContext = context;
        if (this.mContext != null) {
            this.mNoticeManager = (NotificationManager)this.mContext.getSystemService("notification");
            this.mNotice = new Notification();
            this.mNotice.flags |= 0x10;
            this.rv = new RemoteViews(this.mContext.getPackageName(), R.layout.viewjar_progress_notice);
            this.rv.setProgressBar(R.id.progress, 100, 0, false);
            this.mNotice.contentView = this.rv;
        }
    }

    public PercentNotification title(String title) {
        if (this.mNotice != null) {
            int iconId;
            this.mNotice.tickerText = title;
            this.mNotice.icon = iconId = FileUtils.getFileIconId(this.mContext, title);
            this.rv.setImageViewResource(R.id.notice_icon, iconId);
            this.rv.setTextViewText(R.id.title, (CharSequence)title);
        }
        return this;
    }

    public PercentNotification total(long total) {
        this.mTotal = total;
        return this;
    }

    public PercentNotification current(long current) {
        int ratio = (int)(Double.valueOf(current + "") / Double.valueOf(this.mTotal + "") * 100.0);
        this.rv.setTextViewText(R.id.percent, (CharSequence)(ratio + "%"));
        this.rv.setProgressBar(R.id.progress, 100, ratio, false);
        return this;
    }

    public void notice() {
        PendingIntent p;
        Intent i = new Intent(this.mContext, PdfViewActivity.class);
        this.mNotice.contentIntent = p = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)i, (int)0);
        this.mNoticeManager.notify(this.hashCode(), this.mNotice);
    }
}

