/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.db;

import android.app.Application;
import android.content.Context;
import android.util.Log;
import com.szboanda.android.platform.db.SQLiteDao;
import com.szboanda.android.platform.db.SQLiteUpgradeListener;
import com.szboanda.android.platform.util.AppInfoHelper;
import org.json.JSONObject;
import org.xutils.DbManager;
import org.xutils.x;

public class DbHelper {
    private static final String TAG = "DbHelper.java";
    private static Context mGlobalContext;
    private static String mGlobalDbName;
    private static DbManager.DaoConfig mGlobalConfig;

    public static final void initContext(Application application, String appDbName) {
        x.Ext.init((Application)application);
        mGlobalContext = application;
        mGlobalDbName = appDbName;
        mGlobalConfig = new DbManager.DaoConfig().setDbName(mGlobalDbName).setDbVersion(AppInfoHelper.getVersionCode((Context)application)).setDbUpgradeListener((DbManager.DbUpgradeListener)new SQLiteUpgradeListener((Context)application, appDbName));
    }

    public static final SQLiteDao getDao() {
        return DbHelper.getDao(mGlobalDbName);
    }

    public static final synchronized SQLiteDao getDao(String dbName) {
        if (mGlobalContext == null) {
            Log.i((String)TAG, (String)"You must initialize the global context for DbHelper");
            return null;
        }
        SQLiteUpgradeListener listener = new SQLiteUpgradeListener(mGlobalContext, dbName);
        if (mGlobalConfig == null) {
            mGlobalConfig = new DbManager.DaoConfig().setDbName(dbName).setDbVersion(AppInfoHelper.getVersionCode(mGlobalContext)).setDbUpgradeListener((DbManager.DbUpgradeListener)listener);
        }
        return SQLiteDao.getInstance(mGlobalConfig);
    }

    public static void createTableIfNotExist(Class<?> tableCls) {
        DbHelper.getDao().createTableIfNotExist(tableCls);
    }

    public static boolean isTableExist(String tableName) {
        return DbHelper.isTableExist(null, tableName);
    }

    public static boolean isTableExist(String dbName, String tableName) {
        String sql;
        SQLiteDao dao = DbHelper.getDao(dbName);
        JSONObject table = dao.getSingleValue(sql = "SELECT NAME FROM SQLITE_MASTER WHERE TYPE='table' AND NAME='" + tableName + "'");
        return table != null;
    }
}

