/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.image;

import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import java.lang.reflect.Field;
import org.xutils.common.util.DensityUtil;
import org.xutils.common.util.LogUtil;
import org.xutils.http.RequestParams;

public class ImageOptions {
    public static final ImageOptions DEFAULT = new ImageOptions();
    private int maxWidth = 0;
    private int maxHeight = 0;
    private int width = 0;
    private int height = 0;
    private boolean crop = false;
    private int radius = 0;
    private boolean square = false;
    private boolean circular = false;
    private boolean autoRotate = false;
    private boolean compress = true;
    private Bitmap.Config config = Bitmap.Config.RGB_565;
    private boolean ignoreGif = true;
    private int loadingDrawableId = 0;
    private int failureDrawableId = 0;
    private Drawable loadingDrawable = null;
    private Drawable failureDrawable = null;
    private boolean forceLoadingDrawable = true;
    private ImageView.ScaleType placeholderScaleType = ImageView.ScaleType.CENTER_INSIDE;
    private ImageView.ScaleType imageScaleType = ImageView.ScaleType.CENTER_CROP;
    private boolean fadeIn = false;
    private Animation animation = null;
    private boolean useMemCache = true;
    private ParamsBuilder paramsBuilder;

    protected ImageOptions() {
    }

    final void optimizeMaxSize(ImageView view) {
        if (this.width > 0 && this.height > 0) {
            this.maxWidth = this.width;
            this.maxHeight = this.height;
            return;
        }
        int screenWidth = DensityUtil.getScreenWidth();
        int screenHeight = DensityUtil.getScreenHeight();
        if (this.width < 0) {
            this.maxWidth = screenWidth * 3 / 2;
            this.compress = false;
        }
        if (this.height < 0) {
            this.maxHeight = screenHeight * 3 / 2;
            this.compress = false;
        }
        if (view == null && this.maxWidth <= 0 && this.maxHeight <= 0) {
            this.maxWidth = screenWidth;
            this.maxHeight = screenHeight;
        } else {
            int tempWidth = this.maxWidth;
            int tempHeight = this.maxHeight;
            if (view != null) {
                ViewGroup.LayoutParams params = view.getLayoutParams();
                if (params != null) {
                    if (tempWidth <= 0) {
                        if (params.width > 0) {
                            tempWidth = params.width;
                            if (this.width <= 0) {
                                this.width = tempWidth;
                            }
                        } else if (params.width != -2) {
                            tempWidth = view.getWidth();
                        }
                    }
                    if (tempHeight <= 0) {
                        if (params.height > 0) {
                            tempHeight = params.height;
                            if (this.height <= 0) {
                                this.height = tempHeight;
                            }
                        } else if (params.height != -2) {
                            tempHeight = view.getHeight();
                        }
                    }
                }
                if (tempWidth <= 0) {
                    tempWidth = ImageOptions.getImageViewFieldValue(view, "mMaxWidth");
                }
                if (tempHeight <= 0) {
                    tempHeight = ImageOptions.getImageViewFieldValue(view, "mMaxHeight");
                }
            }
            if (tempWidth <= 0) {
                tempWidth = screenWidth;
            }
            if (tempHeight <= 0) {
                tempHeight = screenHeight;
            }
            this.maxWidth = tempWidth;
            this.maxHeight = tempHeight;
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isCrop() {
        return this.crop;
    }

    public int getRadius() {
        return this.radius;
    }

    public boolean isSquare() {
        return this.square;
    }

    public boolean isCircular() {
        return this.circular;
    }

    public boolean isIgnoreGif() {
        return this.ignoreGif;
    }

    public boolean isAutoRotate() {
        return this.autoRotate;
    }

    public boolean isCompress() {
        return this.compress;
    }

    public Bitmap.Config getConfig() {
        return this.config;
    }

    public Drawable getLoadingDrawable(ImageView view) {
        if (this.loadingDrawable == null && this.loadingDrawableId > 0 && view != null) {
            try {
                this.loadingDrawable = view.getResources().getDrawable(this.loadingDrawableId);
            }
            catch (Throwable ex) {
                LogUtil.e(ex.getMessage(), ex);
            }
        }
        return this.loadingDrawable;
    }

    public Drawable getFailureDrawable(ImageView view) {
        if (this.failureDrawable == null && this.failureDrawableId > 0 && view != null) {
            try {
                this.failureDrawable = view.getResources().getDrawable(this.failureDrawableId);
            }
            catch (Throwable ex) {
                LogUtil.e(ex.getMessage(), ex);
            }
        }
        return this.failureDrawable;
    }

    public boolean isFadeIn() {
        return this.fadeIn;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public ImageView.ScaleType getPlaceholderScaleType() {
        return this.placeholderScaleType;
    }

    public ImageView.ScaleType getImageScaleType() {
        return this.imageScaleType;
    }

    public boolean isForceLoadingDrawable() {
        return this.forceLoadingDrawable;
    }

    public boolean isUseMemCache() {
        return this.useMemCache;
    }

    public ParamsBuilder getParamsBuilder() {
        return this.paramsBuilder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageOptions options = (ImageOptions)o;
        if (this.maxWidth != options.maxWidth) {
            return false;
        }
        if (this.maxHeight != options.maxHeight) {
            return false;
        }
        if (this.width != options.width) {
            return false;
        }
        if (this.height != options.height) {
            return false;
        }
        if (this.crop != options.crop) {
            return false;
        }
        if (this.radius != options.radius) {
            return false;
        }
        if (this.square != options.square) {
            return false;
        }
        if (this.circular != options.circular) {
            return false;
        }
        if (this.autoRotate != options.autoRotate) {
            return false;
        }
        if (this.compress != options.compress) {
            return false;
        }
        return this.config == options.config;
    }

    public int hashCode() {
        int result = this.maxWidth;
        result = 31 * result + this.maxHeight;
        result = 31 * result + this.width;
        result = 31 * result + this.height;
        result = 31 * result + (this.crop ? 1 : 0);
        result = 31 * result + this.radius;
        result = 31 * result + (this.square ? 1 : 0);
        result = 31 * result + (this.circular ? 1 : 0);
        result = 31 * result + (this.autoRotate ? 1 : 0);
        result = 31 * result + (this.compress ? 1 : 0);
        result = 31 * result + (this.config != null ? this.config.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("_");
        sb.append(this.maxWidth).append("_");
        sb.append(this.maxHeight).append("_");
        sb.append(this.width).append("_");
        sb.append(this.height).append("_");
        sb.append(this.radius).append("_");
        sb.append(this.config).append("_");
        sb.append(this.crop ? 1 : 0).append(this.square ? 1 : 0).append(this.circular ? 1 : 0);
        sb.append(this.autoRotate ? 1 : 0).append(this.compress ? 1 : 0);
        return sb.toString();
    }

    private static int getImageViewFieldValue(ImageView view, String fieldName) {
        int value = 0;
        try {
            Field field = ImageView.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            int fieldValue = (Integer)field.get(view);
            if (fieldValue > 0 && fieldValue < Integer.MAX_VALUE) {
                value = fieldValue;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return value;
    }

    public static class Builder {
        protected ImageOptions options;

        public Builder() {
            this.newImageOptions();
        }

        protected void newImageOptions() {
            this.options = new ImageOptions();
        }

        public ImageOptions build() {
            return this.options;
        }

        public Builder setSize(int width, int height) {
            this.options.width = width;
            this.options.height = height;
            return this;
        }

        public Builder setCrop(boolean crop) {
            this.options.crop = crop;
            return this;
        }

        public Builder setRadius(int radius) {
            this.options.radius = radius;
            return this;
        }

        public Builder setSquare(boolean square) {
            this.options.square = square;
            return this;
        }

        public Builder setCircular(boolean circular) {
            this.options.circular = circular;
            return this;
        }

        public Builder setAutoRotate(boolean autoRotate) {
            this.options.autoRotate = autoRotate;
            return this;
        }

        public Builder setConfig(Bitmap.Config config) {
            this.options.config = config;
            return this;
        }

        public Builder setIgnoreGif(boolean ignoreGif) {
            this.options.ignoreGif = ignoreGif;
            return this;
        }

        public Builder setLoadingDrawableId(int loadingDrawableId) {
            this.options.loadingDrawableId = loadingDrawableId;
            return this;
        }

        public Builder setLoadingDrawable(Drawable loadingDrawable) {
            this.options.loadingDrawable = loadingDrawable;
            return this;
        }

        public Builder setFailureDrawableId(int failureDrawableId) {
            this.options.failureDrawableId = failureDrawableId;
            return this;
        }

        public Builder setFailureDrawable(Drawable failureDrawable) {
            this.options.failureDrawable = failureDrawable;
            return this;
        }

        public Builder setFadeIn(boolean fadeIn) {
            this.options.fadeIn = fadeIn;
            return this;
        }

        public Builder setAnimation(Animation animation) {
            this.options.animation = animation;
            return this;
        }

        public Builder setPlaceholderScaleType(ImageView.ScaleType placeholderScaleType) {
            this.options.placeholderScaleType = placeholderScaleType;
            return this;
        }

        public Builder setImageScaleType(ImageView.ScaleType imageScaleType) {
            this.options.imageScaleType = imageScaleType;
            return this;
        }

        public Builder setForceLoadingDrawable(boolean forceLoadingDrawable) {
            this.options.forceLoadingDrawable = forceLoadingDrawable;
            return this;
        }

        public Builder setUseMemCache(boolean useMemCache) {
            this.options.useMemCache = useMemCache;
            return this;
        }

        public Builder setParamsBuilder(ParamsBuilder paramsBuilder) {
            this.options.paramsBuilder = paramsBuilder;
            return this;
        }
    }

    public static interface ParamsBuilder {
        public RequestParams buildParams(RequestParams var1, ImageOptions var2);
    }
}

