/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.loader;

import android.text.TextUtils;
import java.io.InputStream;
import org.xutils.cache.DiskCacheEntity;
import org.xutils.common.util.IOUtil;
import org.xutils.http.RequestParams;
import org.xutils.http.loader.Loader;
import org.xutils.http.request.UriRequest;

class StringLoader
extends Loader<String> {
    private String charset = "UTF-8";
    private String resultStr = null;

    StringLoader() {
    }

    @Override
    public Loader<String> newInstance() {
        return new StringLoader();
    }

    @Override
    public void setParams(RequestParams params) {
        String charset;
        if (params != null && !TextUtils.isEmpty((CharSequence)(charset = params.getCharset()))) {
            this.charset = charset;
        }
    }

    @Override
    public String load(InputStream in) throws Throwable {
        this.resultStr = IOUtil.readStr(in, this.charset);
        return this.resultStr;
    }

    @Override
    public String load(UriRequest request) throws Throwable {
        request.sendRequest();
        return this.load(request.getInputStream());
    }

    @Override
    public String loadFromCache(DiskCacheEntity cacheEntity) throws Throwable {
        if (cacheEntity != null) {
            return cacheEntity.getTextContent();
        }
        return null;
    }

    @Override
    public void save2Cache(UriRequest request) {
        this.saveStringCache(request, this.resultStr);
    }
}

