/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.body;

import android.net.Uri;
import android.text.TextUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.xutils.common.util.KeyValue;
import org.xutils.http.body.RequestBody;

public class UrlEncodedParamsBody
implements RequestBody {
    private byte[] content;
    private String charset = "UTF-8";

    public UrlEncodedParamsBody(List<KeyValue> params, String charset) throws IOException {
        if (!TextUtils.isEmpty((CharSequence)charset)) {
            this.charset = charset;
        }
        StringBuilder contentSb = new StringBuilder();
        if (params != null) {
            for (KeyValue kv : params) {
                String name = kv.key;
                String value = kv.getValueStr();
                if (TextUtils.isEmpty((CharSequence)name) || value == null) continue;
                if (contentSb.length() > 0) {
                    contentSb.append("&");
                }
                contentSb.append(Uri.encode((String)name, (String)this.charset)).append("=").append(Uri.encode((String)value, (String)this.charset));
            }
        }
        this.content = contentSb.toString().getBytes(this.charset);
    }

    @Override
    public long getContentLength() {
        return this.content.length;
    }

    @Override
    public void setContentType(String contentType) {
    }

    @Override
    public String getContentType() {
        return "application/x-www-form-urlencoded;charset=" + this.charset;
    }

    @Override
    public void writeTo(OutputStream sink) throws IOException {
        sink.write(this.content);
        sink.flush();
    }
}

