/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http;

import android.os.Parcelable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xutils.common.util.LogUtil;
import org.xutils.http.RequestParams;

final class RequestParamsHelper {
    private static final ClassLoader BOOT_CL = String.class.getClassLoader();

    private RequestParamsHelper() {
    }

    static void parseKV(Object entity, Class<?> type, ParseKVListener listener) {
        if (entity == null || type == null || type == RequestParams.class || type == Object.class) {
            return;
        }
        ClassLoader cl = type.getClassLoader();
        if (cl == null || cl == BOOT_CL) {
            return;
        }
        Field[] fields = type.getDeclaredFields();
        if (fields != null && fields.length > 0) {
            for (Field field : fields) {
                if (Modifier.isTransient(field.getModifiers()) || field.getType() == Parcelable.Creator.class) continue;
                field.setAccessible(true);
                try {
                    String name = field.getName();
                    Object value = field.get(entity);
                    if (value == null) continue;
                    listener.onParseKV(name, value);
                }
                catch (IllegalAccessException ex) {
                    LogUtil.e(ex.getMessage(), ex);
                }
            }
        }
        RequestParamsHelper.parseKV(entity, type.getSuperclass(), listener);
    }

    static Object parseJSONObject(Object value) throws JSONException {
        if (value == null) {
            return null;
        }
        Object result = value;
        Class<?> cls = value.getClass();
        if (cls.isArray()) {
            JSONArray array = new JSONArray();
            int len = Array.getLength(value);
            for (int i = 0; i < len; ++i) {
                array.put(RequestParamsHelper.parseJSONObject(Array.get(value, i)));
            }
            result = array;
        } else if (value instanceof List) {
            JSONArray array = new JSONArray();
            List list = (List)value;
            for (Object item : list) {
                array.put(RequestParamsHelper.parseJSONObject(item));
            }
            result = array;
        } else if (value instanceof Map) {
            JSONObject jo = new JSONObject();
            Map map = (Map)value;
            for (Map.Entry entry : map.entrySet()) {
                Object k = entry.getKey();
                Object v = entry.getValue();
                if (k == null || v == null) continue;
                jo.put(String.valueOf(k), RequestParamsHelper.parseJSONObject(v));
            }
            result = jo;
        } else {
            ClassLoader cl = cls.getClassLoader();
            if (cl != null && cl != BOOT_CL) {
                final JSONObject jo = new JSONObject();
                RequestParamsHelper.parseKV(value, cls, new ParseKVListener(){

                    @Override
                    public void onParseKV(String name, Object value) {
                        try {
                            value = RequestParamsHelper.parseJSONObject(value);
                            jo.put(name, value);
                        }
                        catch (JSONException ex) {
                            throw new IllegalArgumentException("parse RequestParams to json failed", ex);
                        }
                    }
                });
                result = jo;
            }
        }
        return result;
    }

    static interface ParseKVListener {
        public void onParseKV(String var1, Object var2);
    }
}

