/*
 * Decompiled with CFR 0.152.
 */
package android.backport.webp;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

public final class WebPFactory {
    private static boolean loadSoLibError = false;

    private WebPFactory() {
    }

    public static boolean available() {
        return !loadSoLibError;
    }

    public static Bitmap decodeByteArray(byte[] data, BitmapFactory.Options options) {
        if (WebPFactory.available()) {
            return WebPFactory.nativeDecodeByteArray(data, options);
        }
        return BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)options);
    }

    public static Bitmap decodeFile(String path, BitmapFactory.Options options) {
        if (WebPFactory.available()) {
            return WebPFactory.nativeDecodeFile(path, options);
        }
        return BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
    }

    public static byte[] encodeBitmap(Bitmap bitmap, int quality) {
        if (WebPFactory.available()) {
            return WebPFactory.nativeEncodeBitmap(bitmap, quality);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.WEBP, quality, (OutputStream)out);
        return out.toByteArray();
    }

    private static native Bitmap nativeDecodeByteArray(byte[] var0, BitmapFactory.Options var1);

    private static native Bitmap nativeDecodeFile(String var0, BitmapFactory.Options var1);

    private static native byte[] nativeEncodeBitmap(Bitmap var0, int var1);

    static {
        try {
            System.loadLibrary("webpbackport");
        }
        catch (Throwable ex) {
            loadSoLibError = true;
        }
    }
}

