package com.szboanda.android.platform.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.InputType;
import android.text.TextWatcher;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.PasswordTransformationMethod;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.View.OnFocusChangeListener;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;

/**
 * 带密码可见功能的输入框控件
 * @author  SuHao Create Date：2014-10-28
 */
public class PasswordInputText extends EditText implements  
        OnFocusChangeListener, TextWatcher { 
	
	/**有输入内容时，右边出现的删除图标*/
    private Drawable mVisibleDrawable; 
    private boolean visible = false;
 
    public PasswordInputText(Context context) { 
    	super(context);
    	init();
    } 
 
    public PasswordInputText(Context context, AttributeSet attrs) { 
    	super(context, attrs);
		init();
    } 
    
    public PasswordInputText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        init();
    }
    
    private void init() { 
    	//获取EditText的DrawableRight,假如没有设置我们就使用默认的图片
    	if(getInputType() == InputType.TYPE_NULL) {
    		setInputType(InputType.TYPE_TEXT_VARIATION_PASSWORD );
    		setTransformationMethod(PasswordTransformationMethod.getInstance());
    	}
    	mVisibleDrawable = getCompoundDrawables()[2]; 
        if (mVisibleDrawable == null) { 
        	mVisibleDrawable = getResources().getDrawable(android.R.drawable.ic_menu_view);//ResourceUtils.getResourcesId(getContext(),ResoureType.DRAWABLE, "base_edit_clear_drawable")); 
        } 
        mVisibleDrawable.setBounds(0, 0, mVisibleDrawable.getIntrinsicWidth(), mVisibleDrawable.getIntrinsicHeight()); 
        setVisibleIconVisible(false); 
        setOnFocusChangeListener(this); 
        addTextChangedListener(this); 
    } 
 
 
    /**
     * 因为我们不能直接给EditText设置点击事件，所以我们用记住我们按下的位置来模拟点击事件
     * 当我们按下的位置 在  EditText的宽度 - 图标到控件右边的间距 - 图标的宽度  和
     * EditText的宽度 - 图标到控件右边的间距之间我们就算点击了图标，竖直方向没有考虑
     */
    @Override 
    public boolean onTouchEvent(MotionEvent event) { 
        if (getCompoundDrawables()[2] != null) { 
            if (event.getAction() == MotionEvent.ACTION_UP) { 
            	boolean touchable = event.getX() > (getWidth() 
                        - getPaddingRight() - mVisibleDrawable.getIntrinsicWidth()) 
                        && (event.getX() < ((getWidth() - getPaddingRight())));
                if (touchable) { 
                    if(visible){
                    	visible = false;
                    	setTransformationMethod(PasswordTransformationMethod.getInstance());
                    }else{
                    	visible = true;
                    	setTransformationMethod(HideReturnsTransformationMethod.getInstance());
                    }
                } 
            } 
        } 
 
        return super.onTouchEvent(event); 
    } 
 
    /**
     * 当ClearEditText焦点发生变化的时候，判断里面字符串长度设置清除图标的显示与隐藏
     */
    @Override 
    public void onFocusChange(View v, boolean hasFocus) { 
        if (hasFocus) { 
        	setVisibleIconVisible(getText().length() > 0); 
        } else { 
        	setVisibleIconVisible(false); 
        } 
    } 
 
 
    /**
     * 设置清除图标的显示与隐藏，调用setCompoundDrawables为EditText绘制上去
     * @param visible
     */
    protected void setVisibleIconVisible(boolean visible) { 
        Drawable right = visible ? mVisibleDrawable : null; 
        setCompoundDrawables(getCompoundDrawables()[0], 
                getCompoundDrawables()[1], right, getCompoundDrawables()[3]); 
    } 
     
    
    /**当输入框里面内容发生变化的时候回调的方法*/
    @Override 
    public void onTextChanged(CharSequence s, int start, int count, 
            int after) { 
    	setVisibleIconVisible(s.length() > 0); 
    } 
    @Override 
    public void beforeTextChanged(CharSequence s, int start, int count, int after) {} 
    @Override 
    public void afterTextChanged(Editable s) { } 

   
    /**设置晃动动画*/
    public void setShakeAnimation(){
    	this.setAnimation(shakeAnimation(5));
    }
    
    
    /**
     * 晃动动画
     * @param counts 1秒钟晃动多少下
     * @return
     */
    public static Animation shakeAnimation(int counts){
    	Animation translateAnimation = new TranslateAnimation(0, 10, 0, 0);
    	translateAnimation.setInterpolator(new CycleInterpolator(counts));
    	translateAnimation.setDuration(1000);
    	return translateAnimation;
    }
 
    public String getFieldValue(){
		return getText().toString().trim();
	}
	
}
