package com.szboanda.android.platform.util;

import java.util.List;

import com.baidu.location.BDLocation;
import com.szboanda.android.platform.util.LocationHelper.PinLocationListener;

import android.app.Service;
import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Vibrator;

/** 
 * 类说明：传感器定位帮助类， 晃动手机启动定位
 * @author 苏浩 2015年8月10日
 * @version 1.0
 */

public class SensorLocationHelper {

	//摇一摇事件等
	//感应管理器
	private SensorManager sensorManager;
	//震动器
	private Vibrator vibrator;
	
	private LocationHelper locationHelper;
	

	public SensorLocationHelper(Context context,LocationHelper locationHelper){
		this.locationHelper = locationHelper;
		sensorManager = (SensorManager) context.getSystemService(Service.SENSOR_SERVICE);
		vibrator = (Vibrator)context.getSystemService(Service.VIBRATOR_SERVICE);

		List<Sensor> sensors = sensorManager.getSensorList(Sensor.TYPE_ACCELEROMETER);
		if(sensors != null)
			if(sensors.size() ==0){
				return;
			}
	}
	
	/**不能为空**/
	public void setPinLocationListener(PinLocationListener pLocationListener){
		this.pLocationListener = pLocationListener;
	}
	
	/**
	 * 注册传感器监听器
	 */
	public void registerListener(){
		sensorManager.registerListener(sensorelistener, 
				sensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER), 
				SensorManager.SENSOR_DELAY_NORMAL);
	}
	/**
	 * 注销传感器监听器
	 */
	public void unRegisterListener() {
		//注销重力感应监听事件
		sensorManager.unregisterListener(sensorelistener);
	}
	/**
	 * 监听器
	 */
	private SensorEventListener sensorelistener=new SensorEventListener(){
		
		@Override
		public void onAccuracyChanged(Sensor sensor, int accuracy) {
			//			System.out.println("accuracy:"+accuracy);
		}
		
		//感应器发生改变
		@Override
		public void onSensorChanged(SensorEvent event) {
			int sensorType = event.sensor.getType();
			//读取摇一摇敏感值
			int shakeSenseValue = 16;
			//values[0]:X轴，values[1]：Y轴，values[2]：Z轴
			float[] values = event.values;
			if(sensorType == Sensor.TYPE_ACCELEROMETER){
				if((Math.abs(values[0])>shakeSenseValue||Math.abs(values[1])>shakeSenseValue||Math.abs(values[2])>shakeSenseValue)){
					vibrator.vibrate(500);//震动
					locationHelper.startLocation(pLocationListener);
				}
			}                
		}
	};
	
	/**赋默认值*/
	private PinLocationListener pLocationListener = new PinLocationListener() {
		
		@Override
		public void onSucess(BDLocation location) {
			// TODO Auto-generated method stub
			
		}
		
		@Override
		public void onFailure(int errorCode) {
			// TODO Auto-generated method stub
			
		}
	};
}
