package com.szboanda.android.platform.util;

import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

import android.app.Service;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.widget.Toast;

/**
 * <p>Description:网络工具类 </p>
 * <br>判断网络，获取网络状态，打开网络
 * @author    Siyi Lu    Create Date: 2015-4-30
 */
public class NetworkUtils {
	
	/**
	 * 判断网络是否打开,未指定任何网络类型
	 */
	public static boolean isNetworkOpened(Context context) {
		return isNetworkOpened(context, -1);
	}
	
	public static boolean isWifiTurnOn(Context context){
		return isNetworkOpened(context, ConnectivityManager.TYPE_WIFI);
	}
	
	/**
	 * 判断网络是否打开
	 * @param context 如果为空，报异常
	 * @param explicitType 指定网络类型, 参见ConnectivityManager.TYPE_ 静态变量
	 * @return 
	 */
	public static boolean isNetworkOpened(Context context, int explicitType){
		boolean isconnect = false;
		List<Integer> types = new ArrayList<Integer>();
		//未指定网络类型,判断手机网络或WIFI连接都可以
		types.add(ConnectivityManager.TYPE_MOBILE);
		types.add(ConnectivityManager.TYPE_WIFI);
		if(explicitType != -1){
			//指定网络类型,清除默认添加的,添加指定的
			types.clear();
			types.add(explicitType);
		}
		ConnectivityManager conManager = (ConnectivityManager) context
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo network = conManager.getActiveNetworkInfo();
		if (network != null && network.isConnected()) {
			int type = network.getType();
			if (types.contains(type))
				isconnect = true;
		}
		return isconnect;
	}
	
	/**
	 * 获取网络状态
	 */
	public static String getNetworkState(Context context){
		String netState = "";
		ConnectivityManager conManager = (ConnectivityManager)context
				.getSystemService(Context.CONNECTIVITY_SERVICE);
		NetworkInfo network = conManager.getActiveNetworkInfo();
		if(network != null){
			netState = network.getState().toString();
		}else{
			netState = NetworkInfo.State.DISCONNECTED.toString();
		}
		return netState;
	}
	
	/**
	 * 	just enable mobile data 
	 */
	public static void setMobileDataEnabled(Context context, boolean state){
		setMobileDataEnabled(context, state, null);
	}
	
	/**
	 * 	 enable moblie data,then call back processe
	 *  if need to refresh UI, pass the activity context
	 */
	public static void setMobileDataEnabled(Context context, boolean state, Runnable callback){
		try {
			ConnectivityManager mConnectivityManager = (ConnectivityManager)context.getSystemService(Service.CONNECTIVITY_SERVICE);
			Class<?> cmClass = mConnectivityManager.getClass();
			Class<?>[] argClasses = new Class[1];
			argClasses[0] = boolean.class;
			// 反射ConnectivityManager中hide的方法setMobileDataEnabled，可以开启和关闭移动网络
			Method method = cmClass.getMethod("setMobileDataEnabled",argClasses);
			method.invoke(mConnectivityManager, state);
			//打开网络后即显示提示
			if(callback != null){
//				SysSettingDialogManager dialogManager = SysSettingDialogManager.getInstance(context);
//				dialogManager.setCallBack(callback);
//				dialogManager.showNetProgressDialog();
			}
		} catch (Exception e) {
			e.printStackTrace();
			Toast.makeText(context, "开启移动网络出错！", Toast.LENGTH_SHORT).show();
		}
	}
	
	/** 验证服务器是否连接, 只能在子线程中调用 */
	public static boolean validHostConnected(String serviceUrl) {
		boolean isConnected = false;
		URL url;
		HttpURLConnection conn = null;
		try {
			url = new URL(serviceUrl);
			conn = (HttpURLConnection) url.openConnection();
			// 设置连接超时时间为5秒
			conn.setConnectTimeout(1000 * 5);
			if (conn.getResponseCode() == 200) {
				isConnected = true;
			}
			System.out.println("验证网络连接!");
		} catch (Exception e) {
			e.printStackTrace();
		} finally {
			conn.disconnect();
			conn = null;
			url = null;
		}
		return isConnected;
	}
	
	public static boolean turnOnWifi(Context context){
		return toggleWifi(context, true);
	}
	
	public static boolean turnOffWifi(Context context){
		return toggleWifi(context, false);
	}
	
	private static boolean toggleWifi(Context context, boolean enable){
		if(context != null){
			WifiManager wm = (WifiManager)context.getSystemService(Context.WIFI_SERVICE);
			return wm.setWifiEnabled(enable);
		}else{
			return false;
		}
	}
	

	

}
