package com.szboanda.android.platform.util;

import com.szboanda.android.platform.annotation.AliasColumn;

import org.xutils.db.annotation.Column;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * <p>Description: 实体类转换工具</p>
 * @author    Siyi Lu    Create Date: 2016年4月8日
 */
public class EntityConvertor {

	private Map<String, Field> mEntityFields = null;

	private void initSourceEntityFields(Class<?> cls){
		mEntityFields = new HashMap<String, Field>();
		List<Field> fields = BeanUtil.getDeclaredFields(cls);
		for(Field f:fields){
			Column col = f.getAnnotation(Column.class);
			if(col != null){
				BeanUtil.makeAccessible(f);
				mEntityFields.put(col.name(), f);
			}
		}
	}

	public <S, T> List<T> convertAll(List<S> sourceEntitys, Class<T> targetCls){
		List<T> result = null;
		if(sourceEntitys != null){
			result = new ArrayList<T>();
			for(Object e:sourceEntitys){
				result.add(convert(e, targetCls));
			}
		}
		return result;
	}

	@SuppressWarnings("unchecked")
	public <T> T convert(Object entity, Class<T> targetCls){
		Map<String, Field> fieldMap = analyseAdapteColumn(targetCls);
		Object target = null;
		if(fieldMap != null){
			target = BeanUtil.loadInstance(targetCls);
			if(target != null){
				initSourceEntityFields(entity.getClass());
				Set<String> keys = fieldMap.keySet();
				for(String col:keys){
					Field field = fieldMap.get(col);
					BeanUtil.setFieldValue(target, field, getSourceFieldValue(entity, col));
				}
			}
		}
		return (T)target;
	}

	public Map<String, Field> analyseAdapteColumn(Class<?> cls){
		Field[] fields = cls.getDeclaredFields();
		Map<String, Field> fieldMap = null;
		if(fields != null){
			fieldMap = new HashMap<String, Field>();
			for(Field f:fields){
				Annotation annotation = f.getAnnotation(AliasColumn.class);
				if(annotation != null){
					String fcol = ((AliasColumn)annotation).value();
					fieldMap.put(fcol, f);
				}
			}
		}
		return fieldMap;
	}

	public Object getSourceFieldValue(Object source, String col){
		Field field = mEntityFields.get(col);
		Object value = null;
		try{
			value = field.get(source);
		}catch(Exception e){
			e.printStackTrace();
		}
		return value;
	}

}
