package com.szboanda.android.platform.util;

import android.app.Activity;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.Intent.ShortcutIconResource;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageManager.NameNotFoundException;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.Signature;
import android.database.Cursor;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;

public class AppInfoHelper {
	
	private static final String TAG = "AppInfoHelper.java";
	
	public static int getVersionCode(Context context){
		return getVersionCode(context, null);
	}
	
	public static int getVersionCode(Context context, String packageName){
		int versionCode = 1;
		String targetPackage = TextUtils.isEmpty(packageName) ? 
				context.getPackageName() : packageName;
		try{
			PackageInfo pi = context.getPackageManager().getPackageInfo(targetPackage, 0);
			versionCode = pi.versionCode;
		}catch (Exception e) {
			e.printStackTrace();
		}
		return versionCode;
	}
	
	public static String getVersionName(Context context){
		String versionName = "1.0";
		try{
			PackageInfo pi = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
			versionName = pi.versionName;
		}catch (Exception e) {
			e.printStackTrace();
		}
		return versionName;
	}
	
	/**
	 * 获取第三方应用启动信息
	 * @param appName
	 * @return
	 */
	public static String[] getAppInfo(Context context, String appName){
		String[] result = null;//不分配内存
		PackageManager pg = context.getPackageManager();
		Intent intent = new Intent();
		intent.setAction(android.content.Intent.ACTION_MAIN);
		intent.addCategory(android.content.Intent.CATEGORY_LAUNCHER);
		List<ResolveInfo> lists = pg.queryIntentActivities(intent, 0);
		for(ResolveInfo r:lists){
			ActivityInfo activityInfo = r.activityInfo;
			ApplicationInfo appInfo = activityInfo.applicationInfo;
			String tempAppName = pg.getApplicationLabel(appInfo).toString();
			if(tempAppName.equals(appName)){
				result = new String[]{activityInfo.packageName, activityInfo.name};
				break;
			}
		}
		return result;
	}
	
	/**
	 * 获取第三方应用启动信息
	 * @param packageName
	 * @return
	 */
	public static String getLauncherActivity(Context context, String packageName){
		String result = null;
		PackageManager pg = context.getPackageManager();
		Intent intent = new Intent();
		intent.setAction(android.content.Intent.ACTION_MAIN);
		intent.addCategory(android.content.Intent.CATEGORY_LAUNCHER);
		List<ResolveInfo> lists = pg.queryIntentActivities(intent, 0);
		for(ResolveInfo r:lists){
			ActivityInfo activityInfo = r.activityInfo;
			if(packageName.equals(activityInfo.packageName)){
				result = activityInfo.name;
				break;
			}
		}
		return result;
	}
	
	/**为APP添加快捷方式
	 * @param launchActivity 一定是系统的启动Activity的上下文
	 */
	public static void addAppShortcut(Activity launchActivity){
		PackageManager pm = launchActivity.getPackageManager();
		try{
			ApplicationInfo appInfo = pm.getApplicationInfo(launchActivity.getPackageName(), 0);
			String appName = pm.getApplicationLabel(appInfo).toString();
			if(!hasShortcut(launchActivity, appName)){
				Intent shortcutIntent = new Intent("com.android.launcher.action.INSTALL_SHORTCUT"); 
				shortcutIntent.putExtra(Intent.EXTRA_SHORTCUT_NAME, appName); 
				//不重复添加 
				shortcutIntent.putExtra("duplicate", false); 
				Intent mainIntent = new Intent(Intent.ACTION_MAIN); 
				mainIntent.addCategory(Intent.CATEGORY_LAUNCHER); 
				// 要删除的应用程序的ComponentName，即应用程序包名+activity的名字 
				mainIntent.setClass(launchActivity, launchActivity.getClass()); 
				shortcutIntent.putExtra(Intent.EXTRA_SHORTCUT_INTENT, mainIntent); 
				ShortcutIconResource shortcutIcon = ShortcutIconResource.fromContext(launchActivity, appInfo.icon);
				shortcutIntent.putExtra(Intent.EXTRA_SHORTCUT_ICON_RESOURCE, shortcutIcon); 
				launchActivity.sendBroadcast(shortcutIntent); 
			}
		}catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	/**app快捷方式是否已创建</br>
	 * 其中的uri的拼接方式请参照{@link ContentProvider}的CONTENT_URI的定义,
	 * 弄明白如何自定义一个{@link ContentProvider}后会比较容易理解
	 * @param context
	 * @param appName
	 * @return
	 */
	private static boolean hasShortcut(Context context, String appName){
		boolean result = false;
		Cursor cursor = null;
		ProviderInfo pi = null;
		try{
			pi = queryLauncherContentProvider(context);
			if(pi != null){
				String authority = pi.authority;
				String uri = "content://"+ authority +"/favorites?notify=true";
				ContentResolver resolver = context.getContentResolver(); 
		        cursor = resolver.query(Uri.parse(uri), null, "title=? ", new String[]{appName}, null); 
		        if (cursor != null && cursor.getCount()>0) { 
		        	result = true;
		        	cursor.close(); 
		        } 	
			}
		}catch (Exception e) {
			e.printStackTrace();
			result = true;
			Log.i(TAG, "需要添加的权限：" + pi.readPermission);
			Log.i(TAG, "需要添加的权限：" + pi.writePermission);
			if(cursor != null)
				cursor.close();
		}
		return result;
	}
	
	/**
	 * 查询操作快捷方式的ContentProvider的authorities属性值
	 * @param context
	 * @return
	 */
	private static ProviderInfo queryLauncherContentProvider(Context context){
		PackageManager pm = context.getPackageManager();
		List<ProviderInfo> providerInfos = pm.queryContentProviders(null, 0, 0);
		//测试过联想、三星、HTC、华为四个机型手机，他们提供的操作快捷方式数据库的ContentProvider的读、写权限
		//名称都是约定如下的后缀，因此在这些样本的基础确定用判断这个约定后缀的方式进行查询
		String launcherReadPermissionSuffix = ".launcher.permission.READ_SETTINGS";
		String launcherWritePermissionSuffix = ".launcher.permission.WRITE_SETTINGS";
		ProviderInfo result = null;
		if(providerInfos != null && providerInfos.size()>0){
			for(ProviderInfo pi:providerInfos){
				String readPermission = pi.readPermission;
				String writePermission = pi.writePermission;
				if(readPermission != null && writePermission != null 
						&& readPermission.endsWith(launcherReadPermissionSuffix)
						&& writePermission.endsWith(launcherWritePermissionSuffix)){
					result = pi; 
					break;
				}
			}
		}
		return result;
	}
	
	/**
	 * 判断应用是否可用
	 * @param context
	 * @param packageName
	 * @param activityName
	 * @return
	 */
	public static boolean isAppAvailable(Context context, String packageName, String activityName){
		PackageManager packageManager = context.getPackageManager();
        //指定要查找的Activity Action:com.android.phone.action.TOUCH_DIALER
        Intent intent = new Intent();
        intent.setClassName(packageName, activityName);
        //在系统中查询指定的Activity Action
        List<ResolveInfo> resolveInfo = packageManager
        		.queryIntentActivities(intent, PackageManager.GET_RESOLVED_FILTER);
       return resolveInfo != null && resolveInfo.size() > 0;
	}
	
	public static boolean isAppAvailable(Context context, String packageName){
		PackageManager packageManager = context.getPackageManager();
		PackageInfo pi = null;
		try{
			pi = packageManager.getPackageInfo(packageName
					,PackageManager.GET_ACTIVITIES);
		}catch(Exception e){}
		return pi != null;
	}
	
	/**
	 * 获取未安装Apk的签名
	 * 
	 * @param apkPath
	 * @return
	 */
	public static String getUnInstalledApkSignature(String apkPath) {
		String PATH_PackageParser = "android.content.pm.PackageParser";

		try {
			Class<?> pkgParserCls = Class.forName(PATH_PackageParser);
			Constructor<?> pkgParserCt = pkgParserCls.getConstructor();
            Object pkgParser = pkgParserCt.newInstance();

            Class<?>[] typeArgs = new Class[2];
            typeArgs[0] = File.class;
            typeArgs[1] = Integer.TYPE;

            Method pkgParser_parsePackageMtd = pkgParserCls.getDeclaredMethod(
					"parsePackage", typeArgs);
            Object[] valueArgs = new Object[2];
            valueArgs[0] = new File(apkPath);
			valueArgs[1] = PackageManager.GET_SIGNATURES;
			Object pkgParserPkg = pkgParser_parsePackageMtd.invoke(pkgParser,
					valueArgs);

			typeArgs[0] = pkgParserPkg.getClass();
			typeArgs[1] = Integer.TYPE;

			Method pkgParser_collectCertificatesMtd = pkgParserCls
					.getDeclaredMethod("collectCertificates", typeArgs);
			valueArgs = new Object[2];
			valueArgs[0] = pkgParserPkg;
			valueArgs[1] = PackageManager.GET_SIGNATURES;
			pkgParser_collectCertificatesMtd.invoke(pkgParser, valueArgs);

			Field packageInfoFld = pkgParserPkg.getClass().getDeclaredField(
					"mSignatures");
			Signature[] info = (Signature[]) packageInfoFld.get(pkgParserPkg);
			return info[0].toCharsString();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return "";
	}

	/**
	 * 获取已安装apk签名
	 * 
	 * @param context
	 * @param packageName
	 * @return
	 */
	public static String getInstalledApkSignature(Context context,
			String packageName) {
		PackageManager pm = context.getPackageManager();
		List<PackageInfo> apps = pm.getInstalledPackages(PackageManager.GET_SIGNATURES);
		Iterator<PackageInfo> iter = apps.iterator();
		while (iter.hasNext()) {
			PackageInfo packageinfo = iter.next();
			String thisName = packageinfo.packageName;
			if (thisName.equals(packageName)) {
				return packageinfo.signatures[0].toCharsString();
			}
		}
		return "";
	}
	
	/**
	 * 获取已安装Apk文件的源Apk文件
	 * 如：/data/app/com.sina.weibo-1.apk
	 * 
	 * @param context
	 * @param packageName
	 * @return
	 */
	public static String getApkSourcePath(Context context, String packageName) {
		if (TextUtils.isEmpty(packageName))
			return null;
		try {
			ApplicationInfo appInfo = context.getPackageManager()
					.getApplicationInfo(packageName, 0);
			return appInfo.sourceDir;
		} catch (NameNotFoundException e) {
			e.printStackTrace();
		}
		return null;
	}

}
