package com.szboanda.android.platform.nfc.demo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.szboanda.android.platform.R;
import com.szboanda.android.platform.nfc.INfcListener;
import com.szboanda.android.platform.nfc.INfcOperation;
import com.szboanda.android.platform.nfc.NdefOperation;

/**
 * Created by zhanggenhua on 16/4/14.
 */
public class NdefDemoActivity extends Activity{

    private INfcOperation mNdefOpe;

    private TextView promt;
    private EditText writeTxt;
    private Button btnWrite, btnRead;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_nfc_demo);

        mNdefOpe = new NdefOperation(this);
        mNdefOpe.prepareForegroundDispatch();
        mNdefOpe.setNfcListener(new INfcListener() {
            @Override
            public void onRead(String content) {
                promt.setText(content);
            }
        });

        mNdefOpe.enableAutoRead(true);

        initViews();
        setViews();
    }

    @Override
    protected void onResume() {
        super.onResume();
        mNdefOpe.enableForegroundDispatch();
    }

    @Override
    protected void onPause() {
        super.onPause();
        mNdefOpe.disableForegroundDispatch();
    }

    @Override
    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        mNdefOpe.onNewIntent(intent);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        mNdefOpe.onPrepareForegroundDispatch(requestCode);
    }

    private void initViews(){
        promt = (TextView) findViewById(R.id.promt);
        writeTxt = (EditText) findViewById(R.id.editText);
        btnWrite = (Button) findViewById(R.id.write_btn);
        btnRead = (Button) findViewById(R.id.read_btn);
    }

    private void setViews() {
        btnWrite.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                mNdefOpe.write(writeTxt.getText().toString());
            }
        });
        btnRead.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                promt.setText(mNdefOpe.read());
            }
        });
    }


}
