package com.szboanda.android.platform.http.impl;

import java.net.HttpURLConnection;
import java.net.URL;

import com.szboanda.android.platform.util.NetworkUtils;

import android.content.Context;
import android.net.ConnectivityManager;

/**
 * <p>Description: Vpdn网络连通性验证策略</p>
 * @author    Siyi Lu    Create Date: 2015-7-20
 */
public class VpdnNetValider implements INetConnectValider{

	@Override
	public boolean validNetConnect(Context context, String urlStr) {
		boolean isConnected = false;
		if(NetworkUtils.isNetworkOpened(context, ConnectivityManager.TYPE_MOBILE)){
			HttpURLConnection conn = null;
			try{
				URL url = new URL(urlStr);
				conn = (HttpURLConnection)url.openConnection();
				conn.setConnectTimeout(5*1000);
				if (conn.getResponseCode() == 200) {
					isConnected = true;
				}
			}catch (Exception e) {
				e.printStackTrace();
			}
			conn.disconnect();
			conn = null;
			isConnected = true;
		}
		return isConnected;
	}
	
}
