package com.szboanda.android.platform.http.impl;

import android.text.TextUtils;

import com.szboanda.android.platform.http.IDataProtocol;
import com.szboanda.android.platform.util.BeanUtil;
import com.szboanda.android.platform.util.JsonUtils;

import org.json.JSONArray;
import org.json.JSONObject;

import java.lang.reflect.Type;
import java.util.List;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/28.
 */

public class GroupProtocol implements IDataProtocol {

    private String mDataKey = "";

    @Override
    public void dataKey(String key) {
        mDataKey = key;
    }

    @Override
    public <E> E convert(String result, Type type) {
        List resultList = null;
        if(TextUtils.isEmpty(mDataKey)){
            resultList = BeanUtil.convertArrayStr2Entitys(result, type);
        }else {
            JSONObject resultObject = JsonUtils.parseJsonObject(result);
            JSONArray arrayData = resultObject.optJSONArray(mDataKey);
            if(arrayData != null){
                resultList = BeanUtil.convertArrayStr2Entitys(arrayData.toString(), type);
            }
        }
        return (E)resultList;
    }
}
