package com.szboanda.android.platform.http.impl;

import android.text.TextUtils;

import com.szboanda.android.platform.http.IDataProtocol;
import com.szboanda.android.platform.util.JsonUtils;

import org.json.JSONObject;

import java.lang.reflect.Type;

/**
 * <p>Description：</p>
 *
 * @author Created by Siyi Lu on 2017/2/28.
 */

public class ArrayProtocol implements IDataProtocol {

    private String mOptKey = "";

    @Override
    public void dataKey(String key) {
        mOptKey = key;
    }

    @Override
    public <E> E convert(String result, Type type) {
        if(TextUtils.isEmpty(mOptKey)){
            return (E) JsonUtils.parseJsonArray(result);
        }else{
            JSONObject resultJson = JsonUtils.parseJsonObject(result);
            return (E) resultJson.optJSONArray(mOptKey);
        }
    }
}
