package com.szboanda.android.platform.http;

import org.xutils.common.task.Priority;
import org.xutils.common.util.KeyValue;
import org.xutils.http.HttpMethod;
import org.xutils.http.RequestParams;
import org.xutils.http.app.HttpRetryHandler;
import org.xutils.http.app.RedirectHandler;
import org.xutils.http.app.RequestTracker;

import java.io.File;
import java.net.Proxy;
import java.util.List;
import java.util.concurrent.Executor;

import javax.net.ssl.SSLSocketFactory;

/**
 * <p>Description：网络请求参数包装类，避免与xUtils直接耦合</p>
 *
 * @author Created by Siyi Lu on 2017/3/3.
 */

public class ParamsWrapper {

    public RequestParams mActualParams;

    public ParamsWrapper(){
        mActualParams = new RequestParams();
    }

    public void setCharset(String charset) {
        mActualParams.setCharset(charset);
    }

    public String getCharset() {
        return mActualParams.getCharset();
    }

    public void setMethod(HttpMethod method) {
        mActualParams.setMethod(method);
    }

    public HttpMethod getMethod() {
        return mActualParams.getMethod();
    }

    public boolean isMultipart() {
        return mActualParams.isMultipart();
    }

    public void setMultipart(boolean multipart) {
        mActualParams.setMultipart(multipart);
    }

    /**
     * 以json形式提交body参数
     *
     * @return
     */
    public boolean isAsJsonContent() {
        return mActualParams.isAsJsonContent();
    }

    /**
     * 以json形式提交body参数
     *
     * @param asJsonContent
     */
    public void setAsJsonContent(boolean asJsonContent) {
        mActualParams.setAsJsonContent(asJsonContent);
    }

    /**
     * 覆盖header
     *
     * @param name
     * @param value
     */
    public ParamsWrapper setHeader(String name, String value) {
        mActualParams.setHeader(name, value);
        return this;
    }

    /**
     * 添加header
     *
     * @param name
     * @param value
     */
    public ParamsWrapper addHeader(String name, String value) {
        mActualParams.addHeader(name, value);
        return this;
    }

    /**
     * 添加请求参数(根据请求谓词, 将参数加入QueryString或Body.)
     *
     * @param name  参数名
     * @param value 可以是String, File, InputStream 或 byte[]
     */
    public ParamsWrapper addParameter(String name, Object value) {
        mActualParams.addParameter(name, value);
        return this;
    }

    /**
     * 添加参数至Query String
     *
     * @param name
     * @param value
     */
    public ParamsWrapper addQueryStringParameter(String name, String value) {
        mActualParams.addQueryStringParameter(name, value);
        return this;
    }

    /**
     * 添加参数至Body
     *
     * @param name
     * @param value
     */
    public ParamsWrapper addBodyParameter(String name, String value) {
        mActualParams.addBodyParameter(name, value);
        return this;
    }

    /**
     * 添加body参数
     */
    public ParamsWrapper addBodyParameter(String name, File value) {
        mActualParams.addBodyParameter(name, value);
        return this;
    }

    /**
     * 添加body参数
     *
     * @param name        参数名
     * @param value       可以是String, File, InputStream 或 byte[]
     * @param contentType 可为null
     */
    public ParamsWrapper addBodyParameter(String name, Object value, String contentType) {
        mActualParams.addBodyParameter(name, value, contentType);
        return this;
    }

    /**
     * 添加body参数
     *
     * @param name        参数名
     * @param value       可以是String, File, InputStream 或 byte[]
     * @param contentType 可为null
     * @param fileName    服务端看到的文件名
     */
    public ParamsWrapper addBodyParameter(String name, Object value, String contentType, String fileName) {
        mActualParams.addBodyParameter(name, value, contentType, fileName);
        return this;
    }

    public void setBodyContent(String content) {
        mActualParams.setBodyContent(content);
    }

    public String getBodyContent() {
        return mActualParams.getBodyContent();
    }

    public List<KeyValue> getQueryStringParams() {
        return mActualParams.getQueryStringParams();
    }

    public List<KeyValue> getBodyParams() {
        return mActualParams.getBodyParams();
    }

    public List<KeyValue> getFileParams() {
        return mActualParams.getFileParams();
    }

    public List<KeyValue> getStringParams() {
        return mActualParams.getStringParams();
    }

    public String getStringParameter(String name) {
        return mActualParams.getStringParameter(name);
    }

    public List<KeyValue> getParams(String name) {
        return mActualParams.getParams(name);
    }

    public void clearParams() {
        mActualParams.clearParams();
    }

    public void removeParameter(String name) {
        mActualParams.removeParameter(name);
    }

    public String toJSONString() {
        return mActualParams.toJSONString();
    }

    public String getUri() {
        return mActualParams.getUri();
    }

    public ParamsWrapper setUri(String uri){
        mActualParams.setUri(uri);
        return this;
    }

    public String getCacheKey() {
        return mActualParams.getCacheKey();
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        mActualParams.setSslSocketFactory(sslSocketFactory);
    }

    public SSLSocketFactory getSslSocketFactory() {
        return mActualParams.getSslSocketFactory();
    }

    /**
     * 是否在请求过程中启用cookie, 默认true.
     *
     * @return
     */
    public boolean isUseCookie() {
        return mActualParams.isUseCookie();
    }

    /**
     * 是否在请求过程中启用cookie, 默认true.
     *
     * @param useCookie
     */
    public void setUseCookie(boolean useCookie) {
        mActualParams.setUseCookie(useCookie);
    }

    public Proxy getProxy() {
        return mActualParams.getProxy();
    }

    public void setProxy(Proxy proxy) {
        mActualParams.setProxy(proxy);
    }

    public Priority getPriority() {
        return mActualParams.getPriority();
    }

    public void setPriority(Priority priority) {
        mActualParams.setPriority(priority);
    }

    public int getConnectTimeout() {
        return mActualParams.getConnectTimeout();
    }

    public ParamsWrapper setConnectTimeout(int connectTimeout) {
        mActualParams.setConnectTimeout(connectTimeout);
        return this;
    }

    public int getReadTimeout(){return mActualParams.getReadTimeout();}

    public ParamsWrapper setReadTimeout(int readTimeout){
        mActualParams.setReadTimeout(readTimeout);
        return this;
    }

    public String getCacheDirName() {
        return mActualParams.getCacheDirName();
    }

    public void setCacheDirName(String cacheDirName) {
        mActualParams.setCacheDirName(cacheDirName);
    }

    public long getCacheSize() {
        return mActualParams.getCacheSize();
    }

    public void setCacheSize(long cacheSize) {
        mActualParams.setCacheSize(cacheSize);
    }

    /**
     * 默认缓存存活时间, 单位:毫秒.(如果服务没有返回有效的max-age或Expires)
     *
     * @return
     */
    public long getCacheMaxAge() {
        return mActualParams.getCacheMaxAge();
    }

    /**
     * 默认缓存存活时间, 单位:毫秒.(如果服务没有返回有效的max-age或Expires)
     *
     * @param cacheMaxAge
     */
    public void setCacheMaxAge(long cacheMaxAge) {
        mActualParams.setCacheMaxAge(cacheMaxAge);
    }

    /**
     * 自定义线程池
     *
     * @return
     */
    public Executor getExecutor() {
        return mActualParams.getExecutor();
    }

    /**
     * 自定义线程池
     *
     * @param executor
     */
    public void setExecutor(Executor executor) {
        mActualParams.setExecutor(executor);
    }

    /**
     * 是否在下载是自动断点续传
     */
    public boolean isAutoResume() {
        return mActualParams.isAutoResume();
    }

    /**
     * 设置是否在下载是自动断点续传
     *
     * @param autoResume
     */
    public ParamsWrapper setAutoResume(boolean autoResume) {
        mActualParams.setAutoResume(autoResume);
        return this;
    }

    /**
     * 是否根据头信息自动命名文件
     */
    public boolean isAutoRename() {
        return mActualParams.isAutoRename();
    }

    /**
     * 设置是否根据头信息自动命名文件
     *
     * @param autoRename
     */
    public ParamsWrapper setAutoRename(boolean autoRename) {
        mActualParams.setAutoRename(autoRename);
        return this;
    }

    /**
     * 获取下载文件时文件保存的路径和文件名
     */
    public String getSaveFilePath() {
        return mActualParams.getSaveFilePath();
    }

    /**
     * 设置下载文件时文件保存的路径和文件名
     *
     * @param saveFilePath
     */
    public void setSaveFilePath(String saveFilePath) {
        mActualParams.setSaveFilePath(saveFilePath);
    }

    public int getMaxRetryCount() {
        return mActualParams.getMaxRetryCount();
    }

    public void setMaxRetryCount(int maxRetryCount) {
        mActualParams.setMaxRetryCount(maxRetryCount);
    }

    /**
     * 是否可以被立即停止.
     *
     * @return true: 为请求创建新的线程, 取消时请求线程被立即中断; false: 请求建立过程可能不被立即终止.
     */
    public boolean isCancelFast() {
        return mActualParams.isCancelFast();
    }

    /**
     * 是否可以被立即停止.
     *
     * @param cancelFast true: 为请求创建新的线程, 取消时请求线程被立即中断; false: 请求建立过程可能不被立即终止.
     */
    public void setCancelFast(boolean cancelFast) {
        mActualParams.setCancelFast(cancelFast);
    }

    public int getLoadingUpdateMaxTimeSpan() {
        return mActualParams.getLoadingUpdateMaxTimeSpan();
    }

    /**
     * 进度刷新最大间隔时间(默认300毫秒)
     *
     * @param loadingUpdateMaxTimeSpan
     */
    public void setLoadingUpdateMaxTimeSpan(int loadingUpdateMaxTimeSpan) {
        mActualParams.setLoadingUpdateMaxTimeSpan(loadingUpdateMaxTimeSpan);
    }

    public HttpRetryHandler getHttpRetryHandler() {
        return mActualParams.getHttpRetryHandler();
    }

    public void setHttpRetryHandler(HttpRetryHandler httpRetryHandler) {
        mActualParams.setHttpRetryHandler(httpRetryHandler);
    }

    public RedirectHandler getRedirectHandler() {
        return mActualParams.getRedirectHandler();
    }

    /**
     * 自定义重定向接口, 默认系统自动重定向.
     *
     * @param redirectHandler
     */
    public void setRedirectHandler(RedirectHandler redirectHandler) {
        mActualParams.setRedirectHandler(redirectHandler);
    }

    public RequestTracker getRequestTracker() {
        return mActualParams.getRequestTracker();
    }

    public void setRequestTracker(RequestTracker requestTracker) {
        mActualParams.setRequestTracker(requestTracker);
    }

    public RequestParams getRequestParams(){
        return mActualParams;
    }


}
