package com.szboanda.android.platform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import com.szboanda.android.platform.view.IPinnedHeaderListItem;
import com.szboanda.android.platform.view.ISortableEntity;

public abstract class Sorter<T> {
	
	Map<String, List<T>> sortedMap = new LinkedHashMap<String, List<T>>();
	
	List<T> mDatas = new ArrayList<T>();
	
	public Map<String, List<T>> getSortedMapData(){
		return sortedMap;
	}
	
	public List<T> getSortedData(){
		return mDatas;
	}
	
	@SuppressWarnings({ "unchecked", "rawtypes" })
	public void sortAutoIncrement(List<T> datas){
		
		for(T item:datas){
			//类型名称
			String typeName = ((ISortableEntity)item).getTypeName();
			if(!sortedMap.containsKey(typeName)){
				List<T> items = new ArrayList<T>();
				sortedMap.put(typeName, items);
			}
			sortedMap.get(typeName).add(item);
		}
		
		//排序数据
		for(String key:sortedMap.keySet()){
			List<T> items = sortedMap.get(key);
			if(items.get(0) instanceof Comparable){
				Collections.sort((List<Comparable>)items);
			}
		}
		generateListViewData();
	}
	
	private void generateListViewData(){
		mDatas.clear();
		if(sortedMap != null && sortedMap.size()>0){
			for(String key:sortedMap.keySet()){
				List<T> items = sortedMap.get(key);
				addGroup(items);
			}
		}
	}
	
	private void addGroup(List<T> groupItems){
		T virtualItem = null;
		T groupFirstItem = groupItems.get(0);
		if(mDatas.isEmpty()){
			//未添加过条目时，取第一条创建虚拟组条目
			virtualItem = createVirtualItem(groupFirstItem);
		}else{
			//添加条目时，判断最后一条与当前添加的组是否是同一组类型，
			//不是则需要添加虚拟组条目
			T lastItem = mDatas.get(mDatas.size()-1);
			if(lastItem instanceof ISortableEntity && !((ISortableEntity)lastItem).getTypeName()
					.equals(((ISortableEntity)groupFirstItem).getTypeName())){
				virtualItem = createVirtualItem(groupFirstItem);
			}
		}
		if(virtualItem != null && virtualItem instanceof IPinnedHeaderListItem){
			((IPinnedHeaderListItem)virtualItem).setGroupItem(true);
			mDatas.add(virtualItem);
		}
		mDatas.addAll(groupItems);
	}
	
	/**清除数据*/
	public void clear(){
		sortedMap.clear();
		mDatas.clear();
	}
	
	public abstract T createVirtualItem(T childItem);

}
