/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.http.body;

import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import org.xutils.http.body.InputStreamBody;

public class FileBody
extends InputStreamBody {
    private File file;
    private String contentType;

    public FileBody(File file) throws IOException {
        this(file, null);
    }

    public FileBody(File file, String contentType) throws IOException {
        super(new FileInputStream(file));
        this.file = file;
        this.contentType = contentType;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        if (TextUtils.isEmpty((CharSequence)this.contentType)) {
            this.contentType = FileBody.getFileContentType(this.file);
        }
        return this.contentType;
    }

    public static String getFileContentType(File file) {
        String filename = file.getName();
        String contentType = HttpURLConnection.guessContentTypeFromName(filename);
        contentType = TextUtils.isEmpty((CharSequence)contentType) ? "application/octet-stream" : contentType.replaceFirst("\\/jpg$", "/jpeg");
        return contentType;
    }
}

