/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.db.table;

import android.database.Cursor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.xutils.common.util.LogUtil;
import org.xutils.db.annotation.Column;
import org.xutils.db.converter.ColumnConverter;
import org.xutils.db.converter.ColumnConverterFactory;
import org.xutils.db.sqlite.ColumnDbType;
import org.xutils.db.table.ColumnUtils;

public final class ColumnEntity {
    protected final String name;
    private final String property;
    private final boolean isId;
    private final boolean isAutoId;
    protected final Method getMethod;
    protected final Method setMethod;
    protected final Field columnField;
    protected final ColumnConverter columnConverter;

    ColumnEntity(Class<?> entityType, Field field, Column column) {
        field.setAccessible(true);
        this.columnField = field;
        this.name = column.name();
        this.property = column.property();
        this.isId = column.isId();
        Class<?> fieldType = field.getType();
        this.isAutoId = this.isId && column.autoGen() && ColumnUtils.isAutoIdType(fieldType);
        this.columnConverter = ColumnConverterFactory.getColumnConverter(fieldType);
        this.getMethod = ColumnUtils.findGetMethod(entityType, field);
        if (this.getMethod != null && !this.getMethod.isAccessible()) {
            this.getMethod.setAccessible(true);
        }
        this.setMethod = ColumnUtils.findSetMethod(entityType, field);
        if (this.setMethod != null && !this.setMethod.isAccessible()) {
            this.setMethod.setAccessible(true);
        }
    }

    public void setValueFromCursor(Object entity, Cursor cursor, int index) {
        Object value = this.columnConverter.getFieldValue(cursor, index);
        if (value == null) {
            return;
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, value);
            }
            catch (Throwable e) {
                LogUtil.e(e.getMessage(), e);
            }
        } else {
            try {
                this.columnField.set(entity, value);
            }
            catch (Throwable e) {
                LogUtil.e(e.getMessage(), e);
            }
        }
    }

    public Object getColumnValue(Object entity) {
        Object fieldValue = this.getFieldValue(entity);
        if (this.isAutoId && (fieldValue.equals(0L) || fieldValue.equals(0))) {
            return null;
        }
        return this.columnConverter.fieldValue2DbValue(fieldValue);
    }

    public void setAutoIdValue(Object entity, long value) {
        Number idValue = value;
        if (ColumnUtils.isInteger(this.columnField.getType())) {
            idValue = (int)value;
        }
        if (this.setMethod != null) {
            try {
                this.setMethod.invoke(entity, idValue);
            }
            catch (Throwable e) {
                LogUtil.e(e.getMessage(), e);
            }
        } else {
            try {
                this.columnField.set(entity, idValue);
            }
            catch (Throwable e) {
                LogUtil.e(e.getMessage(), e);
            }
        }
    }

    public Object getFieldValue(Object entity) {
        Object fieldValue = null;
        if (entity != null) {
            if (this.getMethod != null) {
                try {
                    fieldValue = this.getMethod.invoke(entity, new Object[0]);
                }
                catch (Throwable e) {
                    LogUtil.e(e.getMessage(), e);
                }
            } else {
                try {
                    fieldValue = this.columnField.get(entity);
                }
                catch (Throwable e) {
                    LogUtil.e(e.getMessage(), e);
                }
            }
        }
        return fieldValue;
    }

    public String getName() {
        return this.name;
    }

    public String getProperty() {
        return this.property;
    }

    public boolean isId() {
        return this.isId;
    }

    public boolean isAutoId() {
        return this.isAutoId;
    }

    public Field getColumnField() {
        return this.columnField;
    }

    public ColumnConverter getColumnConverter() {
        return this.columnConverter;
    }

    public ColumnDbType getColumnDbType() {
        return this.columnConverter.getColumnDbType();
    }

    public String toString() {
        return this.name;
    }
}

