/*
 * Decompiled with CFR 0.152.
 */
package org.xutils.common.task;

import android.os.Looper;
import java.util.concurrent.atomic.AtomicInteger;
import org.xutils.common.Callback;
import org.xutils.common.TaskController;
import org.xutils.common.task.AbsTask;
import org.xutils.common.task.TaskProxy;
import org.xutils.common.util.LogUtil;
import org.xutils.x;

public final class TaskControllerImpl
implements TaskController {
    private static volatile TaskController instance;

    private TaskControllerImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerInstance() {
        if (instance == null) {
            Class<TaskController> clazz = TaskController.class;
            // MONITORENTER : org.xutils.common.TaskController.class
            if (instance == null) {
                instance = new TaskControllerImpl();
            }
            // MONITOREXIT : clazz
        }
        x.Ext.setTaskController(instance);
    }

    @Override
    public <T> AbsTask<T> start(AbsTask<T> task) {
        TaskProxy<T> proxy = null;
        proxy = task instanceof TaskProxy ? (TaskProxy<T>)task : new TaskProxy<T>(task);
        try {
            proxy.doBackground();
        }
        catch (Throwable ex) {
            LogUtil.e(ex.getMessage(), ex);
        }
        return proxy;
    }

    @Override
    public <T> T startSync(AbsTask<T> task) throws Throwable {
        T result = null;
        try {
            task.onWaiting();
            task.onStarted();
            result = task.doBackground();
            task.onSuccess(result);
        }
        catch (Callback.CancelledException cex) {
            task.onCancelled(cex);
        }
        catch (Throwable ex) {
            task.onError(ex, false);
            throw ex;
        }
        finally {
            task.onFinished();
        }
        return result;
    }

    @Override
    public <T extends AbsTask<?>> Callback.Cancelable startTasks(final Callback.GroupCallback<T> groupCallback, T ... tasks) {
        if (tasks == null) {
            throw new IllegalArgumentException("task must not be null");
        }
        Runnable callIfOnAllFinished = new Runnable((AbsTask[])tasks, groupCallback){
            private final int total;
            private final AtomicInteger count;
            final /* synthetic */ AbsTask[] val$tasks;
            final /* synthetic */ Callback.GroupCallback val$groupCallback;
            {
                this.val$tasks = absTaskArray;
                this.val$groupCallback = groupCallback;
                this.total = this.val$tasks.length;
                this.count = new AtomicInteger(0);
            }

            @Override
            public void run() {
                if (this.count.incrementAndGet() == this.total && this.val$groupCallback != null) {
                    this.val$groupCallback.onAllFinished();
                }
            }
        };
        for (T task : tasks) {
            this.start(new TaskProxy((AbsTask)task, (AbsTask)task, callIfOnAllFinished){
                final /* synthetic */ AbsTask val$task;
                final /* synthetic */ Runnable val$callIfOnAllFinished;
                {
                    this.val$task = absTask;
                    this.val$callIfOnAllFinished = runnable;
                    super(task);
                }

                @Override
                protected void onSuccess(Object result) {
                    super.onSuccess(result);
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onSuccess(val$task);
                            }
                        }
                    });
                }

                @Override
                protected void onCancelled(final Callback.CancelledException cex) {
                    super.onCancelled(cex);
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onCancelled(val$task, cex);
                            }
                        }
                    });
                }

                @Override
                protected void onError(final Throwable ex, final boolean isCallbackError) {
                    super.onError(ex, isCallbackError);
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onError(val$task, ex, isCallbackError);
                            }
                        }
                    });
                }

                @Override
                protected void onFinished() {
                    super.onFinished();
                    TaskControllerImpl.this.post(new Runnable(){

                        @Override
                        public void run() {
                            if (groupCallback != null) {
                                groupCallback.onFinished(val$task);
                            }
                            val$callIfOnAllFinished.run();
                        }
                    });
                }
            });
        }
        return new Callback.Cancelable((AbsTask[])tasks){
            final /* synthetic */ AbsTask[] val$tasks;
            {
                this.val$tasks = absTaskArray;
            }

            @Override
            public void cancel() {
                for (AbsTask task : this.val$tasks) {
                    task.cancel();
                }
            }

            @Override
            public boolean isCancelled() {
                boolean isCancelled = true;
                for (AbsTask task : this.val$tasks) {
                    if (task.isCancelled()) continue;
                    isCancelled = false;
                }
                return isCancelled;
            }
        };
    }

    @Override
    public void autoPost(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            TaskProxy.sHandler.post(runnable);
        }
    }

    @Override
    public void post(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        TaskProxy.sHandler.post(runnable);
    }

    @Override
    public void postDelayed(Runnable runnable, long delayMillis) {
        if (runnable == null) {
            return;
        }
        TaskProxy.sHandler.postDelayed(runnable, delayMillis);
    }

    @Override
    public void run(Runnable runnable) {
        if (!TaskProxy.sDefaultExecutor.isBusy()) {
            TaskProxy.sDefaultExecutor.execute(runnable);
        } else {
            new Thread(runnable).start();
        }
    }

    @Override
    public void removeCallbacks(Runnable runnable) {
        TaskProxy.sHandler.removeCallbacks(runnable);
    }
}

