/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.ContentResolver;
import android.content.Intent;
import android.os.Bundle;
import android.util.Base64;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;

public class PrintDialogActivity
extends Activity {
    private static final String PRINT_DIALOG_URL = "https://www.google.com/cloudprint/dialog.html";
    private static final String JS_INTERFACE = "AndroidPrintDialog";
    private static final String CONTENT_TRANSFER_ENCODING = "base64";
    private static final String ZXING_URL = "http://zxing.appspot.com";
    private static final int ZXING_SCAN_REQUEST = 65743;
    private static final String CLOSE_POST_MESSAGE_NAME = "cp-dialog-on-close";
    private WebView dialogWebView;
    Intent cloudPrintIntent;
    private int resultCode;

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.resultCode = -1;
        this.setContentView(2130903044);
        this.dialogWebView = (WebView)this.findViewById(2131230760);
        this.cloudPrintIntent = this.getIntent();
        WebSettings settings = this.dialogWebView.getSettings();
        settings.setJavaScriptEnabled(true);
        this.dialogWebView.setWebViewClient((WebViewClient)new PrintDialogWebClient());
        this.dialogWebView.addJavascriptInterface((Object)new PrintDialogJavaScriptInterface(), JS_INTERFACE);
        this.dialogWebView.loadUrl(PRINT_DIALOG_URL);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent intent) {
        if (requestCode == 65743 && resultCode == -1) {
            this.dialogWebView.loadUrl(intent.getStringExtra("SCAN_RESULT"));
        }
    }

    final class PrintDialogJavaScriptInterface {
        PrintDialogJavaScriptInterface() {
        }

        public String getType() {
            return PrintDialogActivity.this.cloudPrintIntent.getType();
        }

        public String getTitle() {
            return PrintDialogActivity.this.cloudPrintIntent.getExtras().getString("title");
        }

        public String getContent() {
            try {
                ContentResolver contentResolver = PrintDialogActivity.this.getContentResolver();
                InputStream is = contentResolver.openInputStream(PrintDialogActivity.this.cloudPrintIntent.getData());
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                int n = is.read(buffer);
                while (n >= 0) {
                    baos.write(buffer, 0, n);
                    n = is.read(buffer);
                }
                is.close();
                baos.flush();
                return Base64.encodeToString((byte[])baos.toByteArray(), (int)0);
            }
            catch (Throwable e) {
                PrintDialogActivity.this.resultCode = 0;
                PrintDialogActivity.this.setResult(PrintDialogActivity.this.resultCode);
                PrintDialogActivity.this.finish();
                e.printStackTrace();
                return "";
            }
        }

        public String getEncoding() {
            return PrintDialogActivity.CONTENT_TRANSFER_ENCODING;
        }

        public void onPostMessage(String message) {
            if (message.startsWith(PrintDialogActivity.CLOSE_POST_MESSAGE_NAME)) {
                PrintDialogActivity.this.setResult(PrintDialogActivity.this.resultCode);
                PrintDialogActivity.this.finish();
            }
        }
    }

    private final class PrintDialogWebClient
    extends WebViewClient {
        private PrintDialogWebClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            if (url.startsWith(PrintDialogActivity.ZXING_URL)) {
                Intent intentScan = new Intent("com.google.zxing.client.android.SCAN");
                intentScan.putExtra("SCAN_MODE", "QR_CODE_MODE");
                try {
                    PrintDialogActivity.this.startActivityForResult(intentScan, 65743);
                }
                catch (ActivityNotFoundException error) {
                    view.loadUrl(url);
                }
            } else {
                view.loadUrl(url);
            }
            return false;
        }

        public void onPageFinished(WebView view, String url) {
            if (PrintDialogActivity.PRINT_DIALOG_URL.equals(url)) {
                view.loadUrl("javascript:printDialog.setPrintDocument(printDialog.createPrintDocument(window.AndroidPrintDialog.getType(),window.AndroidPrintDialog.getTitle(),window.AndroidPrintDialog.getContent(),window.AndroidPrintDialog.getEncoding()))");
                view.loadUrl("javascript:window.addEventListener('message',function(evt){window.AndroidPrintDialog.onPostMessage(evt.data)}, false)");
            }
        }
    }
}

