/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.BitmapHolder;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.OpaqueImageView;
import com.artifex.mupdfdemo.PatchInfo;
import com.artifex.mupdfdemo.TextProcessor;
import com.artifex.mupdfdemo.TextSelector;
import com.artifex.mupdfdemo.TextWord;
import java.util.ArrayList;
import java.util.Iterator;

public abstract class PageView
extends ViewGroup {
    private static final int HIGHLIGHT_COLOR = -2145029460;
    private static final int LINK_COLOR = -2136182235;
    private static final int BOX_COLOR = -12303105;
    private static final int INK_COLOR = -65536;
    private static final float INK_THICKNESS = 10.0f;
    private static final int BACKGROUND_COLOR = -1;
    private static final int PROGRESS_DIALOG_DELAY = 200;
    protected final Context mContext;
    protected int mPageNumber;
    private Point mParentSize;
    protected Point mSize;
    protected float mSourceScale;
    private ImageView mEntire;
    private BitmapHolder mEntireBmh;
    private AsyncTask<Void, Void, TextWord[][]> mGetText;
    private AsyncTask<Void, Void, LinkInfo[]> mGetLinkInfo;
    private AsyncTask<Void, Void, Bitmap> mDrawEntire;
    private Point mPatchViewSize;
    private Rect mPatchArea;
    private ImageView mPatch;
    private BitmapHolder mPatchBmh;
    private AsyncTask<PatchInfo, Void, PatchInfo> mDrawPatch;
    private RectF[] mSearchBoxes;
    protected LinkInfo[] mLinks;
    private RectF mSelectBox;
    private TextWord[][] mText;
    private RectF mItemSelectBox;
    protected ArrayList<ArrayList<PointF>> mDrawing;
    private View mSearchView;
    private boolean mIsBlank;
    private boolean mHighlightLinks;
    private ProgressBar mBusyIndicator;
    private final Handler mHandler = new Handler();

    public PageView(Context c, Point parentSize) {
        super(c);
        this.mContext = c;
        this.mParentSize = parentSize;
        this.setBackgroundColor(-1);
        this.mEntireBmh = new BitmapHolder();
        this.mPatchBmh = new BitmapHolder();
    }

    protected abstract Bitmap drawPage(int var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract Bitmap updatePage(BitmapHolder var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract LinkInfo[] getLinkInfo();

    protected abstract TextWord[][] getText();

    protected abstract void addMarkup(PointF[] var1, Annotation.Type var2);

    private void reinit() {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancel(true);
            this.mDrawEntire = null;
        }
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancel(true);
            this.mDrawPatch = null;
        }
        if (this.mGetLinkInfo != null) {
            this.mGetLinkInfo.cancel(true);
            this.mGetLinkInfo = null;
        }
        if (this.mGetText != null) {
            this.mGetText.cancel(true);
            this.mGetText = null;
        }
        this.mIsBlank = true;
        this.mPageNumber = 0;
        if (this.mSize == null) {
            this.mSize = this.mParentSize;
        }
        if (this.mEntire != null) {
            this.mEntire.setImageBitmap(null);
            this.mEntireBmh.setBm(null);
        }
        if (this.mPatch != null) {
            this.mPatch.setImageBitmap(null);
            this.mPatchBmh.setBm(null);
        }
        this.mPatchViewSize = null;
        this.mPatchArea = null;
        this.mSearchBoxes = null;
        this.mLinks = null;
        this.mSelectBox = null;
        this.mText = null;
        this.mItemSelectBox = null;
    }

    public void releaseResources() {
        this.reinit();
        if (this.mBusyIndicator != null) {
            this.removeView((View)this.mBusyIndicator);
            this.mBusyIndicator = null;
        }
    }

    public void blank(int page) {
        this.reinit();
        this.mPageNumber = page;
        if (this.mBusyIndicator == null) {
            this.mBusyIndicator = new ProgressBar(this.mContext);
            this.mBusyIndicator.setIndeterminate(true);
            this.mBusyIndicator.setBackgroundResource(2130837504);
            this.addView((View)this.mBusyIndicator);
        }
        this.setBackgroundColor(-1);
    }

    public void setPage(int page, PointF size) {
        Point newSize;
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancel(true);
            this.mDrawEntire = null;
        }
        this.mIsBlank = false;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
        this.mPageNumber = page;
        if (this.mEntire == null) {
            this.mEntire = new OpaqueImageView(this.mContext);
            this.mEntire.setScaleType(ImageView.ScaleType.FIT_CENTER);
            this.addView((View)this.mEntire);
        }
        this.mSourceScale = Math.min((float)this.mParentSize.x / size.x, (float)this.mParentSize.y / size.y);
        this.mSize = newSize = new Point((int)(size.x * this.mSourceScale), (int)(size.y * this.mSourceScale));
        this.mEntire.setImageBitmap(null);
        this.mEntireBmh.setBm(null);
        this.mGetLinkInfo = new AsyncTask<Void, Void, LinkInfo[]>(){

            protected LinkInfo[] doInBackground(Void ... v) {
                return PageView.this.getLinkInfo();
            }

            @Override
            protected void onPostExecute(LinkInfo[] v) {
                PageView.this.mLinks = v;
                PageView.this.invalidate();
            }
        };
        this.mGetLinkInfo.execute((Void[])new Void[0]);
        this.mDrawEntire = new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... v) {
                return PageView.this.drawPage(PageView.this.mSize.x, PageView.this.mSize.y, 0, 0, PageView.this.mSize.x, PageView.this.mSize.y);
            }

            @Override
            protected void onPreExecute() {
                PageView.this.setBackgroundColor(-1);
                PageView.this.mEntire.setImageBitmap(null);
                PageView.this.mEntireBmh.setBm(null);
                if (PageView.this.mBusyIndicator == null) {
                    PageView.this.mBusyIndicator = new ProgressBar(PageView.this.mContext);
                    PageView.this.mBusyIndicator.setIndeterminate(true);
                    PageView.this.mBusyIndicator.setBackgroundResource(2130837504);
                    PageView.this.addView((View)PageView.this.mBusyIndicator);
                    PageView.this.mBusyIndicator.setVisibility(4);
                    PageView.this.mHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            if (PageView.this.mBusyIndicator != null) {
                                PageView.this.mBusyIndicator.setVisibility(0);
                            }
                        }
                    }, 200L);
                }
            }

            @Override
            protected void onPostExecute(Bitmap bm) {
                PageView.this.removeView((View)PageView.this.mBusyIndicator);
                PageView.this.mBusyIndicator = null;
                PageView.this.mEntire.setImageBitmap(bm);
                PageView.this.mEntireBmh.setBm(bm);
                PageView.this.setBackgroundColor(0);
            }
        };
        this.mDrawEntire.execute((Void[])new Void[0]);
        if (this.mSearchView == null) {
            this.mSearchView = new View(this.mContext){

                protected void onDraw(final Canvas canvas) {
                    int n;
                    int n2;
                    Object[] objectArray;
                    super.onDraw(canvas);
                    final float scale = PageView.this.mSourceScale * (float)this.getWidth() / (float)PageView.this.mSize.x;
                    final Paint paint = new Paint();
                    if (!PageView.this.mIsBlank && PageView.this.mSearchBoxes != null) {
                        paint.setColor(-2145029460);
                        objectArray = PageView.this.mSearchBoxes;
                        n2 = objectArray.length;
                        n = 0;
                        while (n < n2) {
                            RectF rect = objectArray[n];
                            canvas.drawRect(rect.left * scale, rect.top * scale, rect.right * scale, rect.bottom * scale, paint);
                            ++n;
                        }
                    }
                    if (!PageView.this.mIsBlank && PageView.this.mLinks != null && PageView.this.mHighlightLinks) {
                        paint.setColor(-2136182235);
                        objectArray = PageView.this.mLinks;
                        n2 = PageView.this.mLinks.length;
                        n = 0;
                        while (n < n2) {
                            RectF link = objectArray[n];
                            canvas.drawRect(link.rect.left * scale, link.rect.top * scale, link.rect.right * scale, link.rect.bottom * scale, paint);
                            ++n;
                        }
                    }
                    if (PageView.this.mSelectBox != null && PageView.this.mText != null) {
                        paint.setColor(-2145029460);
                        PageView.this.processSelectedText(new TextProcessor(){
                            RectF rect;

                            @Override
                            public void onStartLine() {
                                this.rect = new RectF();
                            }

                            @Override
                            public void onWord(TextWord word) {
                                this.rect.union((RectF)word);
                            }

                            @Override
                            public void onEndLine() {
                                if (!this.rect.isEmpty()) {
                                    canvas.drawRect(this.rect.left * scale, this.rect.top * scale, this.rect.right * scale, this.rect.bottom * scale, paint);
                                }
                            }
                        });
                    }
                    if (PageView.this.mItemSelectBox != null) {
                        paint.setStyle(Paint.Style.STROKE);
                        paint.setColor(-12303105);
                        canvas.drawRect(((PageView)PageView.this).mItemSelectBox.left * scale, ((PageView)PageView.this).mItemSelectBox.top * scale, ((PageView)PageView.this).mItemSelectBox.right * scale, ((PageView)PageView.this).mItemSelectBox.bottom * scale, paint);
                    }
                    if (PageView.this.mDrawing != null) {
                        Path path = new Path();
                        for (ArrayList<PointF> arc : PageView.this.mDrawing) {
                            if (arc.size() < 2) continue;
                            Iterator<PointF> iit = arc.iterator();
                            PointF p = iit.next();
                            float mX = p.x * scale;
                            float mY = p.y * scale;
                            path.moveTo(mX, mY);
                            while (iit.hasNext()) {
                                p = iit.next();
                                float x = p.x * scale;
                                float y = p.y * scale;
                                path.quadTo(mX, mY, (x + mX) / 2.0f, (y + mY) / 2.0f);
                                mX = x;
                                mY = y;
                            }
                            path.lineTo(mX, mY);
                        }
                        paint.setAntiAlias(true);
                        paint.setDither(true);
                        paint.setStrokeJoin(Paint.Join.ROUND);
                        paint.setStrokeCap(Paint.Cap.ROUND);
                        paint.setStyle(Paint.Style.STROKE);
                        paint.setStrokeWidth(10.0f * scale);
                        paint.setColor(-65536);
                        canvas.drawPath(path, paint);
                    }
                }
            };
            this.addView(this.mSearchView);
        }
        this.requestLayout();
    }

    public void setSearchBoxes(RectF[] searchBoxes) {
        this.mSearchBoxes = searchBoxes;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    public void setLinkHighlighting(boolean f) {
        this.mHighlightLinks = f;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    public void deselectText() {
        this.mSelectBox = null;
        this.mSearchView.invalidate();
    }

    public void selectText(float x0, float y0, float x1, float y1) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX0 = (x0 - (float)this.getLeft()) / scale;
        float docRelY0 = (y0 - (float)this.getTop()) / scale;
        float docRelX1 = (x1 - (float)this.getLeft()) / scale;
        float docRelY1 = (y1 - (float)this.getTop()) / scale;
        this.mSelectBox = docRelY0 <= docRelY1 ? new RectF(docRelX0, docRelY0, docRelX1, docRelY1) : new RectF(docRelX1, docRelY1, docRelX0, docRelY0);
        this.mSearchView.invalidate();
        if (this.mGetText == null) {
            this.mGetText = new AsyncTask<Void, Void, TextWord[][]>(){

                protected TextWord[][] doInBackground(Void ... params) {
                    return PageView.this.getText();
                }

                @Override
                protected void onPostExecute(TextWord[][] result) {
                    PageView.this.mText = result;
                    PageView.this.mSearchView.invalidate();
                }
            };
            this.mGetText.execute((Void[])new Void[0]);
        }
    }

    public void startDraw(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        if (this.mDrawing == null) {
            this.mDrawing = new ArrayList();
        }
        ArrayList<PointF> arc = new ArrayList<PointF>();
        arc.add(new PointF(docRelX, docRelY));
        this.mDrawing.add(arc);
    }

    public void continueDraw(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        if (this.mDrawing != null && this.mDrawing.size() > 0) {
            ArrayList<PointF> arc = this.mDrawing.get(this.mDrawing.size() - 1);
            arc.add(new PointF(docRelX, docRelY));
            this.mSearchView.invalidate();
        }
    }

    public void cancelDraw() {
        this.mDrawing = null;
        this.mSearchView.invalidate();
    }

    protected PointF[][] getDraw() {
        if (this.mDrawing == null) {
            return null;
        }
        PointF[][] path = new PointF[this.mDrawing.size()][];
        int i = 0;
        while (i < this.mDrawing.size()) {
            ArrayList<PointF> arc = this.mDrawing.get(i);
            path[i] = arc.toArray(new PointF[arc.size()]);
            ++i;
        }
        return path;
    }

    protected void processSelectedText(TextProcessor tp) {
        new TextSelector(this.mText, this.mSelectBox).select(tp);
    }

    public void setItemSelectBox(RectF rect) {
        this.mItemSelectBox = rect;
        if (this.mSearchView != null) {
            this.mSearchView.invalidate();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int y;
        int x;
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case 0: {
                x = this.mSize.x;
                break;
            }
            default: {
                x = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case 0: {
                y = this.mSize.y;
                break;
            }
            default: {
                y = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
        }
        this.setMeasuredDimension(x, y);
        if (this.mBusyIndicator != null) {
            int limit = Math.min(this.mParentSize.x, this.mParentSize.y) / 2;
            this.mBusyIndicator.measure(Integer.MIN_VALUE | limit, Integer.MIN_VALUE | limit);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        if (this.mEntire != null) {
            this.mEntire.layout(0, 0, w, h);
        }
        if (this.mSearchView != null) {
            this.mSearchView.layout(0, 0, w, h);
        }
        if (this.mPatchViewSize != null) {
            if (this.mPatchViewSize.x != w || this.mPatchViewSize.y != h) {
                this.mPatchViewSize = null;
                this.mPatchArea = null;
                if (this.mPatch != null) {
                    this.mPatch.setImageBitmap(null);
                    this.mPatchBmh.setBm(null);
                }
            } else {
                this.mPatch.layout(this.mPatchArea.left, this.mPatchArea.top, this.mPatchArea.right, this.mPatchArea.bottom);
            }
        }
        if (this.mBusyIndicator != null) {
            int bw = this.mBusyIndicator.getMeasuredWidth();
            int bh = this.mBusyIndicator.getMeasuredHeight();
            this.mBusyIndicator.layout((w - bw) / 2, (h - bh) / 2, (w + bw) / 2, (h + bh) / 2);
        }
    }

    public void addHq(boolean update) {
        Rect viewArea = new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        if (viewArea.width() != this.mSize.x || viewArea.height() != this.mSize.y) {
            boolean completeRedraw;
            boolean area_unchanged;
            Point patchViewSize = new Point(viewArea.width(), viewArea.height());
            Rect patchArea = new Rect(0, 0, this.mParentSize.x, this.mParentSize.y);
            if (!patchArea.intersect(viewArea)) {
                return;
            }
            patchArea.offset(-viewArea.left, -viewArea.top);
            boolean bl = area_unchanged = patchArea.equals((Object)this.mPatchArea) && patchViewSize.equals((Object)this.mPatchViewSize);
            if (area_unchanged && !update) {
                return;
            }
            boolean bl2 = completeRedraw = !area_unchanged || !update;
            if (this.mDrawPatch != null) {
                this.mDrawPatch.cancel(true);
                this.mDrawPatch = null;
            }
            if (completeRedraw) {
                this.mPatchBmh.drop();
                this.mPatchBmh = new BitmapHolder();
            }
            if (this.mPatch == null) {
                this.mPatch = new OpaqueImageView(this.mContext);
                this.mPatch.setScaleType(ImageView.ScaleType.FIT_CENTER);
                this.addView((View)this.mPatch);
                this.mSearchView.bringToFront();
            }
            this.mDrawPatch = new AsyncTask<PatchInfo, Void, PatchInfo>(){

                protected PatchInfo doInBackground(PatchInfo ... v) {
                    v[0].bm = v[0].completeRedraw ? PageView.this.drawPage(v[0].patchViewSize.x, v[0].patchViewSize.y, v[0].patchArea.left, v[0].patchArea.top, v[0].patchArea.width(), v[0].patchArea.height()) : PageView.this.updatePage(v[0].bmh, v[0].patchViewSize.x, v[0].patchViewSize.y, v[0].patchArea.left, v[0].patchArea.top, v[0].patchArea.width(), v[0].patchArea.height());
                    return v[0];
                }

                @Override
                protected void onPostExecute(PatchInfo v) {
                    if (PageView.this.mPatchBmh == v.bmh) {
                        PageView.this.mPatchViewSize = v.patchViewSize;
                        PageView.this.mPatchArea = v.patchArea;
                        if (v.bm != null) {
                            PageView.this.mPatch.setImageBitmap(v.bm);
                            v.bmh.setBm(v.bm);
                            v.bm = null;
                        }
                        PageView.this.mPatch.layout(((PageView)PageView.this).mPatchArea.left, ((PageView)PageView.this).mPatchArea.top, ((PageView)PageView.this).mPatchArea.right, ((PageView)PageView.this).mPatchArea.bottom);
                        PageView.this.invalidate();
                    }
                }
            };
            this.mDrawPatch.execute((PatchInfo[])new PatchInfo[]{new PatchInfo(patchViewSize, patchArea, this.mPatchBmh, completeRedraw)});
        }
    }

    public void update() {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancel(true);
            this.mDrawEntire = null;
        }
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancel(true);
            this.mDrawPatch = null;
        }
        this.mDrawEntire = new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... v) {
                return PageView.this.updatePage(PageView.this.mEntireBmh, PageView.this.mSize.x, PageView.this.mSize.y, 0, 0, PageView.this.mSize.x, PageView.this.mSize.y);
            }

            @Override
            protected void onPostExecute(Bitmap bm) {
                if (bm != null) {
                    PageView.this.mEntire.setImageBitmap(bm);
                    PageView.this.mEntireBmh.setBm(bm);
                }
                PageView.this.invalidate();
            }
        };
        this.mDrawEntire.execute((Void[])new Void[0]);
        this.addHq(true);
    }

    public void removeHq() {
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancel(true);
            this.mDrawPatch = null;
        }
        this.mPatchViewSize = null;
        this.mPatchArea = null;
        if (this.mPatch != null) {
            this.mPatch.setImageBitmap(null);
            this.mPatchBmh.setBm(null);
        }
    }

    public int getPage() {
        return this.mPageNumber;
    }

    public boolean isOpaque() {
        return true;
    }
}

