/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.AlertDialog;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.RectF;
import android.os.Build;
import android.widget.EditText;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.BitmapHolder;
import com.artifex.mupdfdemo.Hit;
import com.artifex.mupdfdemo.LinkInfo;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.MuPDFView;
import com.artifex.mupdfdemo.PageView;
import com.artifex.mupdfdemo.PassClickResult;
import com.artifex.mupdfdemo.PassClickResultChoice;
import com.artifex.mupdfdemo.PassClickResultText;
import com.artifex.mupdfdemo.PassClickResultVisitor;
import com.artifex.mupdfdemo.TextProcessor;
import com.artifex.mupdfdemo.TextWord;
import java.util.ArrayList;

public class MuPDFPageView
extends PageView
implements MuPDFView {
    private final MuPDFCore mCore;
    private AsyncTask<Void, Void, PassClickResult> mPassClick;
    private RectF[] mWidgetAreas;
    private Annotation[] mAnnotations;
    private int mSelectedAnnotationIndex = -1;
    private AsyncTask<Void, Void, RectF[]> mLoadWidgetAreas;
    private AsyncTask<Void, Void, Annotation[]> mLoadAnnotations;
    private AlertDialog.Builder mTextEntryBuilder;
    private AlertDialog.Builder mChoiceEntryBuilder;
    private AlertDialog mTextEntry;
    private EditText mEditText;
    private AsyncTask<String, Void, Boolean> mSetWidgetText;
    private AsyncTask<String, Void, Void> mSetWidgetChoice;
    private AsyncTask<PointF[], Void, Void> mAddStrikeOut;
    private AsyncTask<PointF[][], Void, Void> mAddInk;
    private AsyncTask<Integer, Void, Void> mDeleteAnnotation;
    private Runnable changeReporter;

    public MuPDFPageView(Context c, MuPDFCore core, Point parentSize) {
        super(c, parentSize);
        this.mCore = core;
    }

    @Override
    public LinkInfo hitLink(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        LinkInfo[] linkInfoArray = this.mLinks;
        int n = this.mLinks.length;
        int n2 = 0;
        while (n2 < n) {
            LinkInfo l = linkInfoArray[n2];
            if (l.rect.contains(docRelX, docRelY)) {
                return l;
            }
            ++n2;
        }
        return null;
    }

    private void invokeTextDialog(String text) {
        this.mEditText.setText((CharSequence)text);
        this.mTextEntry.getWindow().setSoftInputMode(5);
        this.mTextEntry.show();
    }

    private void invokeChoiceDialog(final String[] options) {
        this.mChoiceEntryBuilder.setItems((CharSequence[])options, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                MuPDFPageView.this.mSetWidgetChoice = new AsyncTask<String, Void, Void>(){

                    protected Void doInBackground(String ... params) {
                        String[] sel = new String[]{params[0]};
                        MuPDFPageView.this.mCore.setFocusedWidgetChoiceSelected(sel);
                        return null;
                    }

                    @Override
                    protected void onPostExecute(Void result) {
                        MuPDFPageView.this.changeReporter.run();
                    }
                };
                MuPDFPageView.this.mSetWidgetChoice.execute(options[which]);
            }
        });
        AlertDialog dialog = this.mChoiceEntryBuilder.create();
        dialog.show();
    }

    @Override
    public void setChangeReporter(Runnable reporter) {
        this.changeReporter = reporter;
    }

    @Override
    public Hit passClickEvent(float x, float y) {
        int i;
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        final float docRelX = (x - (float)this.getLeft()) / scale;
        final float docRelY = (y - (float)this.getTop()) / scale;
        boolean hit = false;
        if (this.mAnnotations != null) {
            i = 0;
            while (i < this.mAnnotations.length) {
                if (this.mAnnotations[i].contains(docRelX, docRelY)) {
                    hit = true;
                    break;
                }
                ++i;
            }
            if (hit) {
                switch (this.mAnnotations[i].type) {
                    case HIGHLIGHT: 
                    case UNDERLINE: 
                    case SQUIGGLY: 
                    case STRIKEOUT: 
                    case INK: {
                        this.mSelectedAnnotationIndex = i;
                        this.setItemSelectBox(this.mAnnotations[i]);
                        return Hit.Annotation;
                    }
                }
            }
        }
        this.mSelectedAnnotationIndex = -1;
        this.setItemSelectBox(null);
        if (!MuPDFCore.javascriptSupported()) {
            return Hit.Nothing;
        }
        if (this.mWidgetAreas != null) {
            i = 0;
            while (i < this.mWidgetAreas.length && !hit) {
                if (this.mWidgetAreas[i].contains(docRelX, docRelY)) {
                    hit = true;
                }
                ++i;
            }
        }
        if (hit) {
            this.mPassClick = new AsyncTask<Void, Void, PassClickResult>(){

                protected PassClickResult doInBackground(Void ... arg0) {
                    return MuPDFPageView.this.mCore.passClickEvent(MuPDFPageView.this.mPageNumber, docRelX, docRelY);
                }

                @Override
                protected void onPostExecute(PassClickResult result) {
                    if (result.changed) {
                        MuPDFPageView.this.changeReporter.run();
                    }
                    result.acceptVisitor(new PassClickResultVisitor(){

                        @Override
                        public void visitText(PassClickResultText result) {
                            MuPDFPageView.this.invokeTextDialog(result.text);
                        }

                        @Override
                        public void visitChoice(PassClickResultChoice result) {
                            MuPDFPageView.this.invokeChoiceDialog(result.options);
                        }
                    });
                }
            };
            this.mPassClick.execute((Void[])new Void[0]);
            return Hit.Widget;
        }
        return Hit.Nothing;
    }

    @Override
    public boolean copySelection() {
        final StringBuilder text = new StringBuilder();
        this.processSelectedText(new TextProcessor(){
            StringBuilder line;

            @Override
            public void onStartLine() {
                this.line = new StringBuilder();
            }

            @Override
            public void onWord(TextWord word) {
                if (this.line.length() > 0) {
                    this.line.append(' ');
                }
                this.line.append(word.w);
            }

            @Override
            public void onEndLine() {
                if (text.length() > 0) {
                    text.append('\n');
                }
                text.append((CharSequence)this.line);
            }
        });
        if (text.length() == 0) {
            return false;
        }
        int currentApiVersion = Build.VERSION.SDK_INT;
        if (currentApiVersion >= 11) {
            ClipboardManager cm = (ClipboardManager)this.mContext.getSystemService("clipboard");
            cm.setPrimaryClip(ClipData.newPlainText((CharSequence)"MuPDF", (CharSequence)text));
        } else {
            android.text.ClipboardManager cm = (android.text.ClipboardManager)this.mContext.getSystemService("clipboard");
            cm.setText((CharSequence)text);
        }
        this.deselectText();
        return true;
    }

    @Override
    public boolean markupSelection(final Annotation.Type type) {
        final ArrayList quadPoints = new ArrayList();
        this.processSelectedText(new TextProcessor(){
            RectF rect;

            @Override
            public void onStartLine() {
                this.rect = new RectF();
            }

            @Override
            public void onWord(TextWord word) {
                this.rect.union((RectF)word);
            }

            @Override
            public void onEndLine() {
                if (!this.rect.isEmpty()) {
                    quadPoints.add(new PointF(this.rect.left, this.rect.bottom));
                    quadPoints.add(new PointF(this.rect.right, this.rect.bottom));
                    quadPoints.add(new PointF(this.rect.right, this.rect.top));
                    quadPoints.add(new PointF(this.rect.left, this.rect.top));
                }
            }
        });
        if (quadPoints.size() == 0) {
            return false;
        }
        this.mAddStrikeOut = new AsyncTask<PointF[], Void, Void>(){

            protected Void doInBackground(PointF[] ... params) {
                MuPDFPageView.this.addMarkup(params[0], type);
                return null;
            }

            @Override
            protected void onPostExecute(Void result) {
                MuPDFPageView.this.loadAnnotations();
                MuPDFPageView.this.update();
            }
        };
        this.mAddStrikeOut.execute((Params[])new PointF[][]{quadPoints.toArray(new PointF[quadPoints.size()])});
        this.deselectText();
        return true;
    }

    @Override
    public void deleteSelectedAnnotation() {
        if (this.mSelectedAnnotationIndex != -1) {
            if (this.mDeleteAnnotation != null) {
                this.mDeleteAnnotation.cancel(true);
            }
            this.mDeleteAnnotation = new AsyncTask<Integer, Void, Void>(){

                protected Void doInBackground(Integer ... params) {
                    MuPDFPageView.this.mCore.deleteAnnotation(MuPDFPageView.this.mPageNumber, params[0]);
                    return null;
                }

                @Override
                protected void onPostExecute(Void result) {
                    MuPDFPageView.this.loadAnnotations();
                    MuPDFPageView.this.update();
                }
            };
            this.mDeleteAnnotation.execute((Integer[])new Integer[]{this.mSelectedAnnotationIndex});
            this.mSelectedAnnotationIndex = -1;
            this.setItemSelectBox(null);
        }
    }

    @Override
    public void deselectAnnotation() {
        this.mSelectedAnnotationIndex = -1;
        this.setItemSelectBox(null);
    }

    @Override
    public boolean saveDraw() {
        PointF[][] path = this.getDraw();
        if (path == null) {
            return false;
        }
        if (this.mAddInk != null) {
            this.mAddInk.cancel(true);
            this.mAddInk = null;
        }
        this.mAddInk = new AsyncTask<PointF[][], Void, Void>(){

            protected Void doInBackground(PointF[][] ... params) {
                MuPDFPageView.this.mCore.addInkAnnotation(MuPDFPageView.this.mPageNumber, params[0]);
                return null;
            }

            @Override
            protected void onPostExecute(Void result) {
                MuPDFPageView.this.loadAnnotations();
                MuPDFPageView.this.update();
            }
        };
        this.mAddInk.execute((Params[])new PointF[][][]{this.getDraw()});
        this.cancelDraw();
        return true;
    }

    @Override
    protected Bitmap drawPage(int sizeX, int sizeY, int patchX, int patchY, int patchWidth, int patchHeight) {
        return this.mCore.drawPage(this.mPageNumber, sizeX, sizeY, patchX, patchY, patchWidth, patchHeight);
    }

    @Override
    protected Bitmap updatePage(BitmapHolder h, int sizeX, int sizeY, int patchX, int patchY, int patchWidth, int patchHeight) {
        return this.mCore.updatePage(h, this.mPageNumber, sizeX, sizeY, patchX, patchY, patchWidth, patchHeight);
    }

    @Override
    protected LinkInfo[] getLinkInfo() {
        return this.mCore.getPageLinks(this.mPageNumber);
    }

    @Override
    protected TextWord[][] getText() {
        return this.mCore.textLines(this.mPageNumber);
    }

    @Override
    protected void addMarkup(PointF[] quadPoints, Annotation.Type type) {
        this.mCore.addMarkupAnnotation(this.mPageNumber, quadPoints, type);
    }

    private void loadAnnotations() {
        this.mAnnotations = null;
        if (this.mLoadAnnotations != null) {
            this.mLoadAnnotations.cancel(true);
        }
        this.mLoadAnnotations = new AsyncTask<Void, Void, Annotation[]>(){

            protected Annotation[] doInBackground(Void ... params) {
                return MuPDFPageView.this.mCore.getAnnoations(MuPDFPageView.this.mPageNumber);
            }

            @Override
            protected void onPostExecute(Annotation[] result) {
                MuPDFPageView.this.mAnnotations = result;
            }
        };
        this.mLoadAnnotations.execute((Void[])new Void[0]);
    }

    @Override
    public void setPage(final int page, PointF size) {
        this.loadAnnotations();
        this.mLoadWidgetAreas = new AsyncTask<Void, Void, RectF[]>(){

            protected RectF[] doInBackground(Void ... arg0) {
                return MuPDFPageView.this.mCore.getWidgetAreas(page);
            }

            @Override
            protected void onPostExecute(RectF[] result) {
                MuPDFPageView.this.mWidgetAreas = result;
            }
        };
        this.mLoadWidgetAreas.execute((Void[])new Void[0]);
        super.setPage(page, size);
    }

    @Override
    public void setScale(float scale) {
    }

    @Override
    public void releaseResources() {
        if (this.mPassClick != null) {
            this.mPassClick.cancel(true);
            this.mPassClick = null;
        }
        if (this.mLoadWidgetAreas != null) {
            this.mLoadWidgetAreas.cancel(true);
            this.mLoadWidgetAreas = null;
        }
        if (this.mLoadAnnotations != null) {
            this.mLoadAnnotations.cancel(true);
            this.mLoadAnnotations = null;
        }
        if (this.mSetWidgetText != null) {
            this.mSetWidgetText.cancel(true);
            this.mSetWidgetText = null;
        }
        if (this.mSetWidgetChoice != null) {
            this.mSetWidgetChoice.cancel(true);
            this.mSetWidgetChoice = null;
        }
        if (this.mAddStrikeOut != null) {
            this.mAddStrikeOut.cancel(true);
            this.mAddStrikeOut = null;
        }
        if (this.mDeleteAnnotation != null) {
            this.mDeleteAnnotation.cancel(true);
            this.mDeleteAnnotation = null;
        }
        super.releaseResources();
    }
}

