/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.artifex.mupdfdemo.Annotation;
import com.artifex.mupdfdemo.AsyncTask;
import com.artifex.mupdfdemo.BitmapHolder;
import com.artifex.mupdfdemo.MuPDFCore;
import com.artifex.mupdfdemo.OpaqueImageView;
import com.artifex.mupdfdemo.PatchInfo;
import java.util.ArrayList;

public abstract class DocumentView
extends ViewGroup {
    private static final int BACKGROUND_COLOR = -1;
    protected final Context mContext;
    protected int mPageNumber;
    private Point mParentSize;
    protected Point mSize;
    protected float mSourceScale;
    private ImageView mEntire;
    private BitmapHolder mEntireBmh;
    private AsyncTask<Void, Void, Bitmap> mDrawEntire;
    private Point mPatchViewSize;
    private Rect mPatchArea;
    private ImageView mPatch;
    private BitmapHolder mPatchBmh;
    private AsyncTask<PatchInfo, Void, PatchInfo> mDrawPatch;
    protected ArrayList<ArrayList<PointF>> mDrawing;
    private boolean mIsBlank;
    private final MuPDFCore mCore;

    public DocumentView(Context c, MuPDFCore core, Point parentSize) {
        super(c);
        this.mContext = c;
        this.mCore = core;
        this.mParentSize = parentSize;
        this.setBackgroundColor(-1);
        this.mEntireBmh = new BitmapHolder();
        this.mPatchBmh = new BitmapHolder();
    }

    protected Bitmap drawPage(int sizeX, int sizeY, int patchX, int patchY, int patchWidth, int patchHeight) {
        return this.mCore.drawPage(this.mPageNumber, sizeX, sizeY, patchX, patchY, patchWidth, patchHeight);
    }

    protected Bitmap updatePage(BitmapHolder h, int sizeX, int sizeY, int patchX, int patchY, int patchWidth, int patchHeight) {
        return this.mCore.updatePage(h, this.mPageNumber, sizeX, sizeY, patchX, patchY, patchWidth, patchHeight);
    }

    protected void addMarkup(PointF[] quadPoints, Annotation.Type type) {
        this.mCore.addMarkupAnnotation(this.mPageNumber, quadPoints, type);
    }

    private void reinit() {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancel(true);
            this.mDrawEntire = null;
        }
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancel(true);
            this.mDrawPatch = null;
        }
        this.mIsBlank = true;
        this.mPageNumber = 0;
        if (this.mSize == null) {
            this.mSize = this.mParentSize;
        }
        if (this.mEntire != null) {
            this.mEntire.setImageBitmap(null);
            this.mEntireBmh.setBm(null);
        }
        if (this.mPatch != null) {
            this.mPatch.setImageBitmap(null);
            this.mPatchBmh.setBm(null);
        }
        this.mPatchViewSize = null;
        this.mPatchArea = null;
    }

    public void releaseResources() {
        this.reinit();
    }

    public void blank(int page) {
        this.reinit();
        this.mPageNumber = page;
        this.setBackgroundColor(-1);
    }

    public void setPage(int page, PointF size) {
        Point newSize;
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancel(true);
            this.mDrawEntire = null;
        }
        this.mIsBlank = false;
        this.mPageNumber = page;
        if (this.mEntire == null) {
            this.mEntire = new OpaqueImageView(this.mContext);
            this.mEntire.setScaleType(ImageView.ScaleType.FIT_CENTER);
            this.addView((View)this.mEntire);
        }
        this.mSourceScale = Math.min((float)this.mParentSize.x / size.x, (float)this.mParentSize.y / size.y);
        this.mSize = newSize = new Point((int)(size.x * this.mSourceScale), (int)(size.y * this.mSourceScale));
        this.mEntire.setImageBitmap(null);
        this.mEntireBmh.setBm(null);
        this.mDrawEntire = new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... v) {
                return DocumentView.this.drawPage(DocumentView.this.mSize.x, DocumentView.this.mSize.y, 0, 0, DocumentView.this.mSize.x, DocumentView.this.mSize.y);
            }

            @Override
            protected void onPreExecute() {
                DocumentView.this.setBackgroundColor(-1);
                DocumentView.this.mEntire.setImageBitmap(null);
                DocumentView.this.mEntireBmh.setBm(null);
            }

            @Override
            protected void onPostExecute(Bitmap bm) {
                DocumentView.this.mEntire.setImageBitmap(bm);
                DocumentView.this.mEntireBmh.setBm(bm);
                DocumentView.this.setBackgroundColor(0);
            }
        };
        this.mDrawEntire.execute((Void[])new Void[0]);
        this.requestLayout();
    }

    public void startDraw(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        if (this.mDrawing == null) {
            this.mDrawing = new ArrayList();
        }
        ArrayList<PointF> arc = new ArrayList<PointF>();
        arc.add(new PointF(docRelX, docRelY));
        this.mDrawing.add(arc);
    }

    public void continueDraw(float x, float y) {
        float scale = this.mSourceScale * (float)this.getWidth() / (float)this.mSize.x;
        float docRelX = (x - (float)this.getLeft()) / scale;
        float docRelY = (y - (float)this.getTop()) / scale;
        if (this.mDrawing != null && this.mDrawing.size() > 0) {
            ArrayList<PointF> arc = this.mDrawing.get(this.mDrawing.size() - 1);
            arc.add(new PointF(docRelX, docRelY));
        }
    }

    public void cancelDraw() {
        this.mDrawing = null;
    }

    protected PointF[][] getDraw() {
        if (this.mDrawing == null) {
            return null;
        }
        PointF[][] path = new PointF[this.mDrawing.size()][];
        int i = 0;
        while (i < this.mDrawing.size()) {
            ArrayList<PointF> arc = this.mDrawing.get(i);
            path[i] = arc.toArray(new PointF[arc.size()]);
            ++i;
        }
        return path;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int y;
        int x;
        switch (View.MeasureSpec.getMode((int)widthMeasureSpec)) {
            case 0: {
                x = this.mSize.x;
                break;
            }
            default: {
                x = View.MeasureSpec.getSize((int)widthMeasureSpec);
            }
        }
        switch (View.MeasureSpec.getMode((int)heightMeasureSpec)) {
            case 0: {
                y = this.mSize.y;
                break;
            }
            default: {
                y = View.MeasureSpec.getSize((int)heightMeasureSpec);
            }
        }
        this.setMeasuredDimension(x, y);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int w = right - left;
        int h = bottom - top;
        if (this.mEntire != null) {
            this.mEntire.layout(0, 0, w, h);
        }
        if (this.mPatchViewSize != null) {
            if (this.mPatchViewSize.x != w || this.mPatchViewSize.y != h) {
                this.mPatchViewSize = null;
                this.mPatchArea = null;
                if (this.mPatch != null) {
                    this.mPatch.setImageBitmap(null);
                    this.mPatchBmh.setBm(null);
                }
            } else {
                this.mPatch.layout(this.mPatchArea.left, this.mPatchArea.top, this.mPatchArea.right, this.mPatchArea.bottom);
            }
        }
    }

    public void addHq(boolean update) {
        Rect viewArea = new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
        if (viewArea.width() != this.mSize.x || viewArea.height() != this.mSize.y) {
            boolean completeRedraw;
            boolean area_unchanged;
            Point patchViewSize = new Point(viewArea.width(), viewArea.height());
            Rect patchArea = new Rect(0, 0, this.mParentSize.x, this.mParentSize.y);
            if (!patchArea.intersect(viewArea)) {
                return;
            }
            patchArea.offset(-viewArea.left, -viewArea.top);
            boolean bl = area_unchanged = patchArea.equals((Object)this.mPatchArea) && patchViewSize.equals((Object)this.mPatchViewSize);
            if (area_unchanged && !update) {
                return;
            }
            boolean bl2 = completeRedraw = !area_unchanged || !update;
            if (this.mDrawPatch != null) {
                this.mDrawPatch.cancel(true);
                this.mDrawPatch = null;
            }
            if (completeRedraw) {
                this.mPatchBmh.drop();
                this.mPatchBmh = new BitmapHolder();
            }
            if (this.mPatch == null) {
                this.mPatch = new OpaqueImageView(this.mContext);
                this.mPatch.setScaleType(ImageView.ScaleType.FIT_CENTER);
                this.addView((View)this.mPatch);
            }
            this.mDrawPatch = new AsyncTask<PatchInfo, Void, PatchInfo>(){

                protected PatchInfo doInBackground(PatchInfo ... v) {
                    v[0].bm = v[0].completeRedraw ? DocumentView.this.drawPage(v[0].patchViewSize.x, v[0].patchViewSize.y, v[0].patchArea.left, v[0].patchArea.top, v[0].patchArea.width(), v[0].patchArea.height()) : DocumentView.this.updatePage(v[0].bmh, v[0].patchViewSize.x, v[0].patchViewSize.y, v[0].patchArea.left, v[0].patchArea.top, v[0].patchArea.width(), v[0].patchArea.height());
                    return v[0];
                }

                @Override
                protected void onPostExecute(PatchInfo v) {
                    if (DocumentView.this.mPatchBmh == v.bmh) {
                        DocumentView.this.mPatchViewSize = v.patchViewSize;
                        DocumentView.this.mPatchArea = v.patchArea;
                        if (v.bm != null) {
                            DocumentView.this.mPatch.setImageBitmap(v.bm);
                            v.bmh.setBm(v.bm);
                            v.bm = null;
                        }
                        DocumentView.this.mPatch.layout(((DocumentView)DocumentView.this).mPatchArea.left, ((DocumentView)DocumentView.this).mPatchArea.top, ((DocumentView)DocumentView.this).mPatchArea.right, ((DocumentView)DocumentView.this).mPatchArea.bottom);
                        DocumentView.this.invalidate();
                    }
                }
            };
            this.mDrawPatch.execute((PatchInfo[])new PatchInfo[]{new PatchInfo(patchViewSize, patchArea, this.mPatchBmh, completeRedraw)});
        }
    }

    public void update() {
        if (this.mDrawEntire != null) {
            this.mDrawEntire.cancel(true);
            this.mDrawEntire = null;
        }
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancel(true);
            this.mDrawPatch = null;
        }
        this.mDrawEntire = new AsyncTask<Void, Void, Bitmap>(){

            protected Bitmap doInBackground(Void ... v) {
                return DocumentView.this.updatePage(DocumentView.this.mEntireBmh, DocumentView.this.mSize.x, DocumentView.this.mSize.y, 0, 0, DocumentView.this.mSize.x, DocumentView.this.mSize.y);
            }

            @Override
            protected void onPostExecute(Bitmap bm) {
                if (bm != null) {
                    DocumentView.this.mEntire.setImageBitmap(bm);
                    DocumentView.this.mEntireBmh.setBm(bm);
                }
                DocumentView.this.invalidate();
            }
        };
        this.mDrawEntire.execute((Void[])new Void[0]);
        this.addHq(true);
    }

    public void removeHq() {
        if (this.mDrawPatch != null) {
            this.mDrawPatch.cancel(true);
            this.mDrawPatch = null;
        }
        this.mPatchViewSize = null;
        this.mPatchArea = null;
        if (this.mPatch != null) {
            this.mPatch.setImageBitmap(null);
            this.mPatchBmh.setBm(null);
        }
    }

    public int getPage() {
        return this.mPageNumber;
    }

    public boolean isOpaque() {
        return true;
    }
}

