/*
 * Decompiled with CFR 0.152.
 */
package com.artifex.mupdfdemo;

import android.app.AlertDialog;
import android.app.ListActivity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.os.Environment;
import android.os.FileObserver;
import android.os.Handler;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.artifex.mupdfdemo.ChoosePDFAdapter;
import com.artifex.mupdfdemo.ChoosePDFItem;
import com.artifex.mupdfdemo.MuPDFActivity;
import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ChoosePDFActivity
extends ListActivity {
    private static File mDirectory;
    private static Map<String, Integer> mPositions;
    private File mParent;
    private File[] mDirs;
    private File[] mFiles;
    private Handler mHandler;
    private Runnable mUpdateFiles;
    private ChoosePDFAdapter adapter;

    static {
        mPositions = new HashMap<String, Integer>();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        String storageState = Environment.getExternalStorageState();
        if (!"mounted".equals(storageState) && !"mounted_ro".equals(storageState)) {
            AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
            builder.setTitle(2131099650);
            builder.setMessage(2131099651);
            AlertDialog alert = builder.create();
            alert.setButton(-1, (CharSequence)this.getString(2131099674), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    ChoosePDFActivity.this.finish();
                }
            });
            alert.show();
            return;
        }
        if (mDirectory == null) {
            mDirectory = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        }
        this.adapter = new ChoosePDFAdapter(this.getLayoutInflater());
        this.setListAdapter((ListAdapter)this.adapter);
        this.mHandler = new Handler();
        this.mUpdateFiles = new Runnable(){

            @Override
            public void run() {
                File f;
                Resources res = ChoosePDFActivity.this.getResources();
                String appName = res.getString(2131099648);
                String version = res.getString(2131099649);
                String title = res.getString(2131099656);
                ChoosePDFActivity.this.setTitle(String.format(title, appName, version, mDirectory));
                ChoosePDFActivity.this.mParent = mDirectory.getParentFile();
                ChoosePDFActivity.this.mDirs = mDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                });
                if (ChoosePDFActivity.this.mDirs == null) {
                    ChoosePDFActivity.this.mDirs = new File[0];
                }
                ChoosePDFActivity.this.mFiles = mDirectory.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        if (file.isDirectory()) {
                            return false;
                        }
                        String fname = file.getName().toLowerCase();
                        if (fname.endsWith(".pdf")) {
                            return true;
                        }
                        if (fname.endsWith(".xps")) {
                            return true;
                        }
                        if (fname.endsWith(".cbz")) {
                            return true;
                        }
                        if (fname.endsWith(".png")) {
                            return true;
                        }
                        if (fname.endsWith(".jpe")) {
                            return true;
                        }
                        if (fname.endsWith(".jpeg")) {
                            return true;
                        }
                        if (fname.endsWith(".jpg")) {
                            return true;
                        }
                        if (fname.endsWith(".jfif")) {
                            return true;
                        }
                        if (fname.endsWith(".jfif-tbnl")) {
                            return true;
                        }
                        if (fname.endsWith(".tif")) {
                            return true;
                        }
                        return fname.endsWith(".tiff");
                    }
                });
                if (ChoosePDFActivity.this.mFiles == null) {
                    ChoosePDFActivity.this.mFiles = new File[0];
                }
                Arrays.sort(ChoosePDFActivity.this.mFiles, new Comparator<File>(){

                    @Override
                    public int compare(File arg0, File arg1) {
                        return arg0.getName().compareToIgnoreCase(arg1.getName());
                    }
                });
                Arrays.sort(ChoosePDFActivity.this.mDirs, new Comparator<File>(){

                    @Override
                    public int compare(File arg0, File arg1) {
                        return arg0.getName().compareToIgnoreCase(arg1.getName());
                    }
                });
                ChoosePDFActivity.this.adapter.clear();
                if (ChoosePDFActivity.this.mParent != null) {
                    ChoosePDFActivity.this.adapter.add(new ChoosePDFItem(ChoosePDFItem.Type.PARENT, ChoosePDFActivity.this.getString(2131099675)));
                }
                File[] fileArray = ChoosePDFActivity.this.mDirs;
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    f = fileArray[n2];
                    ChoosePDFActivity.this.adapter.add(new ChoosePDFItem(ChoosePDFItem.Type.DIR, f.getName()));
                    ++n2;
                }
                fileArray = ChoosePDFActivity.this.mFiles;
                n = fileArray.length;
                n2 = 0;
                while (n2 < n) {
                    f = fileArray[n2];
                    ChoosePDFActivity.this.adapter.add(new ChoosePDFItem(ChoosePDFItem.Type.DOC, f.getName()));
                    ++n2;
                }
                ChoosePDFActivity.this.lastPosition();
            }
        };
        this.mHandler.post(this.mUpdateFiles);
        FileObserver observer = new FileObserver(mDirectory.getPath(), 768){

            public void onEvent(int event, String path) {
                ChoosePDFActivity.this.mHandler.post(ChoosePDFActivity.this.mUpdateFiles);
            }
        };
        observer.startWatching();
    }

    private void lastPosition() {
        String p = mDirectory.getAbsolutePath();
        if (mPositions.containsKey(p)) {
            this.getListView().setSelection(mPositions.get(p).intValue());
        }
    }

    protected void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        mPositions.put(mDirectory.getAbsolutePath(), this.getListView().getFirstVisiblePosition());
        if (position < (this.mParent == null ? 0 : 1)) {
            mDirectory = this.mParent;
            this.mHandler.post(this.mUpdateFiles);
            return;
        }
        if ((position -= this.mParent == null ? 0 : 1) < this.mDirs.length) {
            mDirectory = this.mDirs[position];
            this.mHandler.post(this.mUpdateFiles);
            return;
        }
        Uri uri = Uri.parse((String)this.mFiles[position -= this.mDirs.length].getAbsolutePath());
        Intent intent = new Intent((Context)this, MuPDFActivity.class);
        intent.setAction("android.intent.action.VIEW");
        intent.setData(uri);
        this.startActivity(intent);
    }

    protected void onPause() {
        super.onPause();
        mPositions.put(mDirectory.getAbsolutePath(), this.getListView().getFirstVisiblePosition());
    }
}

