/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view.wheel;

import android.content.Context;
import com.szboanda.android.platform.view.wheel.AbstractWheelTextAdapter;

public class NumericWheelAdapter
extends AbstractWheelTextAdapter {
    public static final int DEFAULT_MAX_VALUE = 5;
    private static final int DEFAULT_MIN_VALUE = 0;
    private int minValue;
    private int maxValue;
    private String format;

    public NumericWheelAdapter(Context context) {
        this(context, 0, 5);
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue) {
        this(context, minValue, maxValue, null);
    }

    public NumericWheelAdapter(Context context, int minValue, int maxValue, String format) {
        super(context);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.format = format;
    }

    @Override
    public CharSequence getItemText(int index) {
        if (index >= 0 && index < this.getItemsCount()) {
            int value = this.minValue + index;
            return this.format != null ? String.format(this.format, value) : Integer.toString(value);
        }
        return null;
    }

    @Override
    public int getItemsCount() {
        return this.maxValue - this.minValue + 1;
    }
}

