/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.text.Html;
import android.text.Spanned;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.szboanda.android.platform.util.DimensionUtils;
import com.szboanda.android.platform.util.ViewUtils;
import java.util.ArrayList;
import java.util.List;

@SuppressLint(value={"NewApi"})
public class WheelView
extends ScrollView {
    public static final String TAG = WheelView.class.getSimpleName();
    private Context context;
    private LinearLayout views;
    List<String> items;
    public static final int OFF_SET_DEFAULT = 1;
    int offset = 1;
    int displayItemCount;
    int selectedIndex = 1;
    int initialY;
    Runnable scrollerTask;
    int newCheck = 50;
    int itemHeight = 0;
    int[] selectedAreaBorder;
    private int scrollDirection = -1;
    private static final int SCROLL_DIRECTION_UP = 0;
    private static final int SCROLL_DIRECTION_DOWN = 1;
    Paint paint;
    int viewWidth;
    private OnWheelViewListener onWheelViewListener;

    public WheelView(Context context) {
        super(context);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public WheelView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    protected List<String> getItems() {
        return this.items;
    }

    public void setItems(List<String> list) {
        if (null == this.items) {
            this.items = new ArrayList<String>();
        }
        this.items.clear();
        this.items.addAll(list);
        this.views.removeAllViews();
        this.itemHeight = 0;
        for (int i = 0; i < this.offset; ++i) {
            this.items.add(0, "");
            this.items.add("");
        }
        this.initData();
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    private void init(Context context) {
        this.context = context;
        this.setFillViewport(true);
        this.setVerticalScrollBarEnabled(false);
        this.views = new LinearLayout(context);
        this.views.setOrientation(1);
        this.addView((View)this.views);
        this.scrollerTask = new Runnable(){

            @Override
            public void run() {
                int newY = WheelView.this.getScrollY();
                if (WheelView.this.initialY - newY == 0) {
                    final int remainder = WheelView.this.initialY % WheelView.this.itemHeight;
                    final int divided = WheelView.this.initialY / WheelView.this.itemHeight;
                    if (remainder == 0) {
                        WheelView.this.selectedIndex = divided + WheelView.this.offset;
                        WheelView.this.onSeletedCallBack();
                    } else if (remainder > WheelView.this.itemHeight / 2) {
                        WheelView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder + WheelView.this.itemHeight);
                                WheelView.this.selectedIndex = divided + WheelView.this.offset + 1;
                                WheelView.this.onSeletedCallBack();
                            }
                        });
                    } else {
                        WheelView.this.post(new Runnable(){

                            @Override
                            public void run() {
                                WheelView.this.smoothScrollTo(0, WheelView.this.initialY - remainder);
                                WheelView.this.selectedIndex = divided + WheelView.this.offset;
                                WheelView.this.onSeletedCallBack();
                            }
                        });
                    }
                } else {
                    WheelView.this.initialY = WheelView.this.getScrollY();
                    WheelView.this.postDelayed(WheelView.this.scrollerTask, WheelView.this.newCheck);
                }
            }
        };
    }

    public void startScrollerTask() {
        this.initialY = this.getScrollY();
        this.postDelayed(this.scrollerTask, this.newCheck);
    }

    private void initData() {
        this.displayItemCount = this.offset * 2 + 1;
        for (String item : this.items) {
            this.views.addView((View)this.createView(item));
        }
        this.refreshItemView(0);
    }

    private TextView createView(String item) {
        float textSize = 20.0f;
        Spanned span = Html.fromHtml((String)item);
        TextView tv = new TextView(this.context);
        tv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        tv.setSingleLine(true);
        tv.setTextSize(2, textSize);
        tv.setText((CharSequence)span);
        tv.setMaxEms(5);
        tv.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        tv.setGravity(17);
        int padding = DimensionUtils.dip2Px(this.context, 5);
        tv.setPadding(padding, padding, padding, padding);
        if (0 == this.itemHeight) {
            this.itemHeight = ViewUtils.measureView((View)tv)[1];
            this.views.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, this.itemHeight * this.displayItemCount));
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.getLayoutParams();
            this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(lp.width, this.itemHeight * this.displayItemCount));
        }
        return tv;
    }

    public int[] getAutoMeasureSize(Context context) {
        TextView tv = new TextView(context);
        tv.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        tv.setSingleLine(true);
        tv.setTextSize(2, 20.0f);
        tv.setText((CharSequence)"\u6709\u4e94\u4e2a\u6c49\u5b57");
        tv.setGravity(17);
        int padding = DimensionUtils.dip2Px(context, 5);
        tv.setPadding(padding, padding, padding, padding);
        return new int[]{ViewUtils.measureView((View)tv)[0], ViewUtils.measureView((View)tv)[1] * (this.offset * 2 + 1)};
    }

    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        this.refreshItemView(t);
        this.scrollDirection = t > oldt ? 1 : 0;
    }

    private void refreshItemView(int y) {
        int position = y / this.itemHeight + this.offset;
        int remainder = y % this.itemHeight;
        int divided = y / this.itemHeight;
        if (remainder == 0) {
            position = divided + this.offset;
        } else if (remainder > this.itemHeight / 2) {
            position = divided + this.offset + 1;
        }
        int childSize = this.views.getChildCount();
        for (int i = 0; i < childSize; ++i) {
            TextView itemView = (TextView)this.views.getChildAt(i);
            if (null == itemView) {
                return;
            }
            if (position == i) {
                itemView.setTextColor(Color.parseColor((String)"#0288ce"));
                continue;
            }
            itemView.setTextColor(Color.parseColor((String)"#bbbbbb"));
        }
    }

    private int[] obtainSelectedAreaBorder() {
        if (null == this.selectedAreaBorder) {
            this.selectedAreaBorder = new int[2];
            this.selectedAreaBorder[0] = this.itemHeight * this.offset;
            this.selectedAreaBorder[1] = this.itemHeight * (this.offset + 1);
        }
        return this.selectedAreaBorder;
    }

    public void setBackground(Drawable background) {
        if (this.viewWidth == 0) {
            this.viewWidth = ((Activity)this.context).getWindowManager().getDefaultDisplay().getWidth();
        }
        if (null == this.paint) {
            this.paint = new Paint();
            this.paint.setColor(Color.parseColor((String)"#83cde6"));
            this.paint.setStrokeWidth((float)DimensionUtils.dip2Px(this.context, 1));
        }
        background = new Drawable(){

            public void draw(Canvas canvas) {
                canvas.drawLine(0.0f, (float)WheelView.this.obtainSelectedAreaBorder()[0], (float)WheelView.this.viewWidth, (float)WheelView.this.obtainSelectedAreaBorder()[0], WheelView.this.paint);
                canvas.drawLine(0.0f, (float)WheelView.this.obtainSelectedAreaBorder()[1], (float)WheelView.this.viewWidth, (float)WheelView.this.obtainSelectedAreaBorder()[1], WheelView.this.paint);
            }

            public void setAlpha(int alpha) {
            }

            public void setColorFilter(ColorFilter cf) {
            }

            public int getOpacity() {
                return 0;
            }
        };
        super.setBackground(background);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.viewWidth = w;
        this.setBackground(null);
    }

    private void onSeletedCallBack() {
        if (null != this.onWheelViewListener) {
            this.onWheelViewListener.onSelected(this, this.selectedIndex - this.offset, this.items.get(this.selectedIndex));
        }
    }

    public void setSeletion(int position) {
        final int p = position;
        this.selectedIndex = p + this.offset;
        this.post(new Runnable(){

            @Override
            public void run() {
                WheelView.this.smoothScrollTo(0, p * WheelView.this.itemHeight);
                WheelView.this.onSeletedCallBack();
            }
        });
    }

    public String getSeletedItem() {
        return this.items != null ? this.items.get(this.selectedIndex) : null;
    }

    public int getSeletedIndex() {
        return this.selectedIndex - this.offset;
    }

    public void fling(int velocityY) {
        super.fling(velocityY / 3);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 1) {
            this.startScrollerTask();
        }
        return super.onTouchEvent(ev);
    }

    public OnWheelViewListener getOnWheelViewListener() {
        return this.onWheelViewListener;
    }

    public void setOnWheelViewListener(OnWheelViewListener onWheelViewListener) {
        this.onWheelViewListener = onWheelViewListener;
    }

    public static interface OnWheelViewListener {
        public void onSelected(WheelView var1, int var2, String var3);
    }
}

