/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.view;

import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import com.szboanda.android.platform.view.AutoLineFeedLayout;

public class AutoLineFeedRadioGroup
extends AutoLineFeedLayout {
    private int mCheckedId = -1;
    private CompoundButton.OnCheckedChangeListener mChildOnCheckedChangeListener;
    private boolean mProtectFromCheckedChange = false;
    private OnCheckedChangeListener mOnCheckedChangeListener;
    private PassThroughHierarchyChangeListener mPassThroughListener;

    public AutoLineFeedRadioGroup(Context context) {
        super(context);
        this.init();
    }

    public AutoLineFeedRadioGroup(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    private void init() {
        this.mChildOnCheckedChangeListener = new CheckedStateTracker();
        this.mPassThroughListener = new PassThroughHierarchyChangeListener();
        super.setOnHierarchyChangeListener((ViewGroup.OnHierarchyChangeListener)this.mPassThroughListener);
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener listener) {
        this.mPassThroughListener.mOnHierarchyChangeListener = listener;
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.mCheckedId != -1) {
            this.mProtectFromCheckedChange = true;
            this.setCheckedStateForView(this.mCheckedId, true);
            this.mProtectFromCheckedChange = false;
            this.setCheckedId(this.mCheckedId);
        }
    }

    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (child instanceof RadioButton) {
            RadioButton button = (RadioButton)child;
            if (button.isChecked()) {
                this.mProtectFromCheckedChange = true;
                if (this.mCheckedId != -1) {
                    this.setCheckedStateForView(this.mCheckedId, false);
                }
                this.mProtectFromCheckedChange = false;
                this.setCheckedId(button.getId());
            }
        } else if (child instanceof ViewGroup) {
            RadioButton resBtn = null;
            int len = ((ViewGroup)child).getChildCount();
            for (int i = 0; i < len; ++i) {
                if (!(((ViewGroup)child).getChildAt(i) instanceof RadioButton) || !(resBtn = (RadioButton)((ViewGroup)child).getChildAt(i)).isChecked()) continue;
                this.mProtectFromCheckedChange = true;
                if (this.mCheckedId != -1) {
                    this.setCheckedStateForView(this.mCheckedId, false);
                }
                this.mProtectFromCheckedChange = false;
                this.setCheckedId(resBtn.getId());
            }
        }
        super.addView(child, index, params);
    }

    public RadioButton findRadioButton(ViewGroup group) {
        RadioButton resBtn = null;
        int len = group.getChildCount();
        for (int i = 0; i < len; ++i) {
            if (group.getChildAt(i) instanceof RadioButton) {
                resBtn = (RadioButton)group.getChildAt(i);
                continue;
            }
            if (!(group.getChildAt(i) instanceof ViewGroup)) continue;
            this.findRadioButton((ViewGroup)group.getChildAt(i));
        }
        return resBtn;
    }

    public void check(int id2) {
        if (id2 != -1 && id2 == this.mCheckedId) {
            return;
        }
        if (this.mCheckedId != -1) {
            this.setCheckedStateForView(this.mCheckedId, false);
        }
        if (id2 != -1) {
            this.setCheckedStateForView(id2, true);
        }
        this.setCheckedId(id2);
    }

    private void setCheckedId(int id2) {
        this.mCheckedId = id2;
        if (this.mOnCheckedChangeListener != null) {
            this.mOnCheckedChangeListener.onCheckedChanged(this, this.mCheckedId);
        }
    }

    private void setCheckedStateForView(int viewId, boolean checked) {
        View checkedView = this.findViewById(viewId);
        if (checkedView != null && checkedView instanceof RadioButton) {
            ((RadioButton)checkedView).setChecked(checked);
        }
    }

    public int getCheckedRadioButtonId() {
        return this.mCheckedId;
    }

    public void clearCheck() {
        this.check(-1);
    }

    public void setOnCheckedChangeListener(OnCheckedChangeListener listener) {
        this.mOnCheckedChangeListener = listener;
    }

    private class PassThroughHierarchyChangeListener
    implements ViewGroup.OnHierarchyChangeListener {
        private ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;

        private PassThroughHierarchyChangeListener() {
        }

        public void onChildViewAdded(View parent, final View child) {
            if (parent == AutoLineFeedRadioGroup.this && child instanceof RadioButton) {
                int id2 = child.getId();
                if (id2 == -1) {
                    id2 = child.hashCode();
                    child.setId(id2);
                }
                ((RadioButton)child).setOnCheckedChangeListener(AutoLineFeedRadioGroup.this.mChildOnCheckedChangeListener);
                ((RadioButton)child).setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View arg0) {
                        if (AutoLineFeedRadioGroup.this.mCheckedId != -1 && AutoLineFeedRadioGroup.this.mCheckedId == ((RadioButton)child).getId()) {
                            AutoLineFeedRadioGroup.this.clearCheck();
                        }
                        return true;
                    }
                });
            } else if (parent == AutoLineFeedRadioGroup.this && child instanceof ViewGroup) {
                int len = ((ViewGroup)child).getChildCount();
                for (int i = 0; i < len; ++i) {
                    if (!(((ViewGroup)child).getChildAt(i) instanceof RadioButton)) continue;
                    final RadioButton resBtn = (RadioButton)((ViewGroup)child).getChildAt(i);
                    int id3 = resBtn.getId();
                    if (id3 == -1) {
                        id3 = resBtn.hashCode();
                        resBtn.setId(id3);
                    }
                    resBtn.setOnCheckedChangeListener(AutoLineFeedRadioGroup.this.mChildOnCheckedChangeListener);
                    resBtn.setOnLongClickListener(new View.OnLongClickListener(){

                        public boolean onLongClick(View arg0) {
                            if (AutoLineFeedRadioGroup.this.mCheckedId != -1 && AutoLineFeedRadioGroup.this.mCheckedId == resBtn.getId()) {
                                AutoLineFeedRadioGroup.this.clearCheck();
                            }
                            return true;
                        }
                    });
                }
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewAdded(parent, child);
            }
        }

        public void onChildViewRemoved(View parent, View child) {
            if (parent == AutoLineFeedRadioGroup.this && child instanceof RadioButton) {
                ((RadioButton)child).setOnCheckedChangeListener(null);
            } else if (parent == AutoLineFeedRadioGroup.this && child instanceof ViewGroup) {
                AutoLineFeedRadioGroup.this.findRadioButton((ViewGroup)child).setOnCheckedChangeListener(null);
            }
            if (this.mOnHierarchyChangeListener != null) {
                this.mOnHierarchyChangeListener.onChildViewRemoved(parent, child);
            }
        }
    }

    private class CheckedStateTracker
    implements CompoundButton.OnCheckedChangeListener {
        private CheckedStateTracker() {
        }

        public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
            if (AutoLineFeedRadioGroup.this.mProtectFromCheckedChange) {
                return;
            }
            AutoLineFeedRadioGroup.this.mProtectFromCheckedChange = true;
            if (AutoLineFeedRadioGroup.this.mCheckedId != -1) {
                AutoLineFeedRadioGroup.this.setCheckedStateForView(AutoLineFeedRadioGroup.this.mCheckedId, false);
            }
            AutoLineFeedRadioGroup.this.mProtectFromCheckedChange = false;
            int id2 = buttonView.getId();
            AutoLineFeedRadioGroup.this.setCheckedId(id2);
        }
    }

    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(AutoLineFeedRadioGroup var1, int var2);
    }

    public static class LayoutParams
    extends LinearLayout.LayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int w, int h) {
            super(w, h);
        }

        public LayoutParams(int w, int h, float initWeight) {
            super(w, h, initWeight);
        }

        public LayoutParams(ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        protected void setBaseAttributes(TypedArray a, int widthAttr, int heightAttr) {
        }
    }
}

