/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.util;

import com.szboanda.android.platform.annotation.AliasColumn;
import com.szboanda.android.platform.util.BeanUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xutils.db.annotation.Column;

public class EntityConvertor {
    private Map<String, Field> mEntityFields = null;

    private void initSourceEntityFields(Class<?> cls) {
        this.mEntityFields = new HashMap<String, Field>();
        List<Field> fields = BeanUtil.getDeclaredFields(cls);
        for (Field f : fields) {
            Column col = f.getAnnotation(Column.class);
            if (col == null) continue;
            BeanUtil.makeAccessible(f);
            this.mEntityFields.put(col.name(), f);
        }
    }

    public <S, T> List<T> convertAll(List<S> sourceEntitys, Class<T> targetCls) {
        ArrayList<T> result = null;
        if (sourceEntitys != null) {
            result = new ArrayList<T>();
            for (S e : sourceEntitys) {
                result.add(this.convert(e, targetCls));
            }
        }
        return result;
    }

    public <T> T convert(Object entity, Class<T> targetCls) {
        Map<String, Field> fieldMap = this.analyseAdapteColumn(targetCls);
        T target = null;
        if (fieldMap != null && (target = (T)BeanUtil.loadInstance(targetCls)) != null) {
            this.initSourceEntityFields(entity.getClass());
            Set<String> keys = fieldMap.keySet();
            for (String col : keys) {
                Field field = fieldMap.get(col);
                BeanUtil.setFieldValue(target, field, this.getSourceFieldValue(entity, col));
            }
        }
        return target;
    }

    public Map<String, Field> analyseAdapteColumn(Class<?> cls) {
        Field[] fields = cls.getDeclaredFields();
        HashMap<String, Field> fieldMap = null;
        if (fields != null) {
            fieldMap = new HashMap<String, Field>();
            for (Field f : fields) {
                AliasColumn annotation = f.getAnnotation(AliasColumn.class);
                if (annotation == null) continue;
                String fcol = annotation.value();
                fieldMap.put(fcol, f);
            }
        }
        return fieldMap;
    }

    public Object getSourceFieldValue(Object source, String col) {
        Field field = this.mEntityFields.get(col);
        Object value = null;
        try {
            value = field.get(source);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

