/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.db;

import android.text.TextUtils;
import com.szboanda.android.platform.db.DbHelper;
import com.szboanda.android.platform.db.SQLiteDao;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class TableDao {
    private String mTableName;
    private List<String> mPrimaryKeys = null;
    private JSONArray mFields = null;
    private List<String> mFieldNames = null;
    private SQLiteDao mSQLiteDao = null;

    public TableDao(String tableName) {
        this(null, tableName);
    }

    public TableDao(String dbName, String tableName) {
        this.mSQLiteDao = DbHelper.getDao(dbName);
        this.mTableName = tableName;
        if (!TextUtils.isEmpty((CharSequence)tableName)) {
            this.initTableField();
            this.initPrimaryKey();
        }
    }

    private void initPrimaryKey() {
        try {
            if (this.mFields != null && this.mFields.length() > 0) {
                this.mPrimaryKeys = new ArrayList<String>();
                for (int i = 0; i < this.mFields.length(); ++i) {
                    JSONObject jsonItem = this.mFields.getJSONObject(i);
                    String fieldName = jsonItem.optString("NAME");
                    String pkValue = jsonItem.optString("PK");
                    if (!"1".equals(pkValue)) continue;
                    this.mPrimaryKeys.add(fieldName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initTableField() {
        String sql = "PRAGMA TABLE_INFO('" + this.mTableName + "')";
        this.mFields = this.mSQLiteDao.getListValue(sql);
        if (this.mFields != null && this.mFields.length() > 0) {
            this.mFieldNames = new ArrayList<String>();
            for (int i = 0; i < this.mFields.length(); ++i) {
                JSONObject curJson = this.mFields.optJSONObject(i);
                String field = curJson.optString("NAME");
                this.mFieldNames.add(field);
            }
        }
    }

    public void beginTransaction() {
        this.mSQLiteDao.getDaoConfig().setAllowTransaction(true);
        this.mSQLiteDao.getDatabase().beginTransaction();
    }

    public void endTransaction() {
        this.mSQLiteDao.getDatabase().setTransactionSuccessful();
        this.mSQLiteDao.getDatabase().endTransaction();
    }

    public SQLiteDao getDao() {
        return this.mSQLiteDao;
    }

    public List<String> getPrimaryKeys() {
        return this.mPrimaryKeys;
    }

    public List<String> getTableFields() {
        return this.mFieldNames;
    }

    public void replaceData(JSONObject data) {
        String replaceSql = this.convertJsonToReplaceSql(data);
        this.mSQLiteDao.exeSql(replaceSql);
    }

    public void insertData(JSONObject data) {
        String insertSql = this.convertJsonToInsertSql(data);
        this.mSQLiteDao.exeSql(insertSql);
    }

    public void updateData(JSONObject data) {
        String updateSql = this.convertJsonToUpdateSql(data);
        this.mSQLiteDao.exeSql(updateSql);
    }

    public void deleteData(JSONObject data) {
        String deleteSql = this.convertJsonToDeleteSql(data);
        this.mSQLiteDao.exeSql(deleteSql);
    }

    public void saveListData(List<JSONObject> items) {
        this.beginTransaction();
        for (JSONObject item : items) {
            String sql = this.convertJsonToReplaceSql(item);
            this.mSQLiteDao.exeSql(sql);
        }
        this.endTransaction();
    }

    private String convertJsonToReplaceSql(JSONObject item) {
        String replaceSql = "REPLACE INTO " + this.mTableName + this.convertJsonToColVal(item);
        return replaceSql;
    }

    private String convertJsonToInsertSql(JSONObject item) {
        String insertSql = "INSERT INTO " + this.mTableName + this.convertJsonToColVal(item);
        return insertSql;
    }

    private String convertJsonToColVal(JSONObject item) {
        String columns = "";
        String values = "";
        Iterator iterator = item.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!this.mFieldNames.contains(key)) continue;
            String value = item.optString(key);
            columns = columns + "," + key;
            values = values + ",'" + value + "'";
        }
        columns = "".equals(columns) ? columns : columns.substring(1);
        values = "".equals(values) ? values : values.substring(1);
        return " (" + columns + ") VALUES (" + values + ")";
    }

    private String convertJsonToUpdateSql(JSONObject item) {
        String columns = "";
        String where = " WHERE 1=1 ";
        Iterator iterator = item.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (!this.mFieldNames.contains(key)) continue;
            String value = item.optString(key);
            columns = columns + "," + key + "='" + value + "'";
            if (!this.mPrimaryKeys.contains(key)) continue;
            where = where + " AND " + key + "='" + value + "'";
        }
        columns = columns.substring(1);
        String updateSql = "UPDATE " + this.mTableName + " SET " + columns + where;
        return updateSql;
    }

    private String convertJsonToDeleteSql(JSONObject data) {
        String where = " WHERE 1=1";
        for (String key : this.mPrimaryKeys) {
            String value = data.optString(key);
            where = where + " AND " + key + "='" + value + "'";
        }
        String deleteSql = "DELETE FROM " + this.mTableName + where;
        return deleteSql;
    }
}

