/*
 * Decompiled with CFR 0.152.
 */
package com.szboanda.android.platform.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.text.TextUtils;
import com.szboanda.android.platform.util.BeanUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONObject;
import org.xutils.DbManager;
import org.xutils.common.util.KeyValue;
import org.xutils.db.DbManagerImpl;
import org.xutils.db.Selector;
import org.xutils.db.sqlite.SqlInfo;
import org.xutils.db.sqlite.SqlInfoBuilder;
import org.xutils.db.sqlite.WhereBuilder;
import org.xutils.db.table.DbModel;
import org.xutils.db.table.TableEntity;
import org.xutils.ex.DbException;

public class SQLiteDao
implements DbManager {
    private static SQLiteDao DAO = null;
    private static Object mLock = new Object();
    protected DbManager m3tdPartyDao;

    private SQLiteDao(DbManager.DaoConfig config) {
        this.m3tdPartyDao = DbManagerImpl.getInstance((DbManager.DaoConfig)config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLiteDao getInstance(DbManager.DaoConfig config) {
        if (DAO == null) {
            Object object = mLock;
            synchronized (object) {
                if (DAO == null) {
                    DAO = new SQLiteDao(config);
                }
            }
        }
        return DAO;
    }

    public JSONObject getSingleValue(String sql) {
        JSONArray array = this.getListValue(sql);
        if (array != null && array.length() > 0) {
            return array.optJSONObject(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized JSONArray getListValue(String sql) {
        JSONArray result = null;
        try (Cursor c = null;){
            c = this.m3tdPartyDao.execQuery(sql);
            result = SQLiteDao.convertCursor2Array(c);
        }
        return result;
    }

    public static JSONArray convertCursor2Array(Cursor cursor) {
        JSONArray jsonArray = new JSONArray();
        if (cursor != null && cursor.getCount() > 0) {
            String[] columns = cursor.getColumnNames();
            cursor.moveToFirst();
            while (!cursor.isAfterLast() && columns != null && columns.length != 0) {
                JSONObject jsonObject = new JSONObject();
                for (String columnName : columns) {
                    try {
                        String value = cursor.getString(cursor.getColumnIndex(columnName));
                        if (TextUtils.isEmpty((CharSequence)value) || "null".equals(value)) {
                            jsonObject.put(columnName.toUpperCase(Locale.getDefault()), (Object)"");
                            continue;
                        }
                        jsonObject.put(columnName.toUpperCase(Locale.getDefault()), (Object)value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                jsonArray.put((Object)jsonObject);
                cursor.moveToNext();
            }
        }
        return jsonArray;
    }

    public void exeSql(String sql) {
        try {
            this.m3tdPartyDao.execNonQuery(sql);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <T> List<T> getDataList(List<T> dataList, String[] property, String[] value, Class arg) {
        dataList = new ArrayList<T>();
        try {
            Selector select = this.m3tdPartyDao.selector(arg);
            for (int i = 0; i < property.length; ++i) {
                select.where(property[i], "=", (Object)value[i]);
            }
            dataList = select.findAll();
        }
        catch (DbException e) {
            e.printStackTrace();
        }
        return dataList;
    }

    public DbManager.DaoConfig getDaoConfig() {
        return this.m3tdPartyDao.getDaoConfig();
    }

    public SQLiteDatabase getDatabase() {
        return this.m3tdPartyDao.getDatabase();
    }

    public boolean saveBindingId(Object entity) throws DbException {
        return this.m3tdPartyDao.saveBindingId(entity);
    }

    public void saveOrUpdate(Object entity) throws DbException {
        this.m3tdPartyDao.saveOrUpdate(entity);
    }

    public void save(Object entity) throws DbException {
        this.m3tdPartyDao.save(entity);
    }

    public void replace(Object entity) throws DbException {
        this.m3tdPartyDao.replace(entity);
    }

    public void deleteById(Class<?> entityType, Object idValue) throws DbException {
        this.m3tdPartyDao.deleteById(entityType, idValue);
    }

    public void delete(Object entity) throws DbException {
        this.m3tdPartyDao.delete(entity);
    }

    public void delete(Class<?> entityType) throws DbException {
        this.m3tdPartyDao.delete(entityType);
    }

    public int delete(Class<?> entityType, WhereBuilder whereBuilder) throws DbException {
        return this.m3tdPartyDao.delete(entityType, whereBuilder);
    }

    public void update(Object entity, String ... updateColumnNames) throws DbException {
        this.m3tdPartyDao.update(entity, updateColumnNames);
    }

    public int update(Class<?> entityType, WhereBuilder whereBuilder, KeyValue ... nameValuePairs) throws DbException {
        return this.m3tdPartyDao.update(entityType, whereBuilder, nameValuePairs);
    }

    public <T> T findById(Class<T> entityType, Object idValue) throws DbException {
        return (T)this.m3tdPartyDao.findById(entityType, idValue);
    }

    public <T> T findFirst(Class<T> entityType) throws DbException {
        return (T)this.m3tdPartyDao.findFirst(entityType);
    }

    public <T> List<T> findAll(Class<T> entityType) throws DbException {
        return this.m3tdPartyDao.findAll(entityType);
    }

    public <T> Selector<T> selector(Class<T> entityType) throws DbException {
        return this.m3tdPartyDao.selector(entityType);
    }

    public DbModel findDbModelFirst(SqlInfo sqlInfo) throws DbException {
        return this.m3tdPartyDao.findDbModelFirst(sqlInfo);
    }

    public List<DbModel> findDbModelAll(SqlInfo sqlInfo) throws DbException {
        return this.m3tdPartyDao.findDbModelAll(sqlInfo);
    }

    public <T> TableEntity<T> getTable(Class<T> entityType) throws DbException {
        return this.m3tdPartyDao.getTable(entityType);
    }

    public void dropTable(Class<?> entityType) throws DbException {
        this.m3tdPartyDao.dropTable(entityType);
    }

    public void addColumn(Class<?> entityType, String column) throws DbException {
        this.m3tdPartyDao.addColumn(entityType, column);
    }

    public void dropDb() throws DbException {
        this.m3tdPartyDao.dropDb();
    }

    public void close() throws IOException {
        this.m3tdPartyDao.close();
    }

    public int executeUpdateDelete(SqlInfo sqlInfo) throws DbException {
        return this.m3tdPartyDao.executeUpdateDelete(sqlInfo);
    }

    public int executeUpdateDelete(String sql) throws DbException {
        return this.m3tdPartyDao.executeUpdateDelete(sql);
    }

    public void execNonQuery(SqlInfo sqlInfo) throws DbException {
        this.m3tdPartyDao.execNonQuery(sqlInfo);
    }

    public void execNonQuery(String sql) throws DbException {
        this.m3tdPartyDao.execNonQuery(sql);
    }

    public Cursor execQuery(SqlInfo sqlInfo) throws DbException {
        return this.m3tdPartyDao.execQuery(sqlInfo);
    }

    public Cursor execQuery(String sql) throws DbException {
        return this.m3tdPartyDao.execQuery(sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTableIfNotExist(Class<?> tableCls) {
        block9: {
            try {
                TableEntity<?> table = this.getTable(tableCls);
                if (table.tableIsExist()) break block9;
                Class<?> clazz = table.getClass();
                synchronized (clazz) {
                    if (!table.tableIsExist()) {
                        DbManager.TableCreateListener listener;
                        SqlInfo sqlInfo = SqlInfoBuilder.buildCreateTableSqlInfo(table);
                        this.execNonQuery(sqlInfo);
                        String execAfterTableCreated = table.getOnCreated();
                        if (!TextUtils.isEmpty((CharSequence)execAfterTableCreated)) {
                            this.execNonQuery(execAfterTableCreated);
                        }
                        Method method = TableEntity.class.getDeclaredMethod("setCheckedDatabase", Boolean.TYPE);
                        method.setAccessible(true);
                        if (method != null) {
                            method.invoke(table, true);
                        }
                        if ((listener = this.getDaoConfig().getTableCreateListener()) != null) {
                            listener.onTableCreated((DbManager)this, table);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isTableExist(Class<?> tableCls) {
        boolean exist = false;
        try {
            TableEntity<?> table = this.getTable(tableCls);
            exist = table.tableIsExist();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return exist;
    }

    public <E> List<E> getEntitysBySql(String sql, Type type) {
        List result = null;
        JSONArray array = this.getListValue(sql);
        if (array != null && array.length() > 0) {
            result = BeanUtil.convertArrayStr2Entitys(array.toString(), type);
        }
        return result;
    }
}

