package com.szboanda.android.platform.view.wheel;

import java.util.ArrayList;
import java.util.List;

import android.content.Context;

public class StringWheelAdapter extends AbstractWheelTextAdapter{

	private List<String> mItemsData;

	public StringWheelAdapter(Context context, List<String> items) {
		super(context);
		setTextSize(20);
		this.mItemsData = items;
	}
	
	@Override
	public CharSequence getItemText(int index) {
		if (index >= 0 && index < mItemsData.size()) {
			String item = mItemsData.get(index);
			if (item instanceof CharSequence) {
				return (CharSequence) item;
			}
			return item.toString();
		}
		return "";
	}
	
	public int getItemsCount() {
		return mItemsData.size();
	}
	
	public void setItemsData(List<String> items){
		if(mItemsData == null){
			mItemsData = new ArrayList<String>();
		}
		mItemsData.clear();
		mItemsData.addAll(items);
	}
}
