package com.szboanda.android.platform.view.wheel;

import android.database.DataSetObserver;
import android.view.View;
import android.view.ViewGroup;

import java.util.LinkedList;
import java.util.List;

/**
 * Abstract Wheel adapter.
 */
public abstract class AbstractWheelAdapter implements WheelViewAdapter {
	// Observers
	private List<DataSetObserver> datasetObservers;

    private int scopeFloorIndex = Integer.MIN_VALUE;
    private int scopeUpperIndex = Integer.MAX_VALUE;

	public View getEmptyItem(View convertView, ViewGroup parent) {
		return null;
	}

	public void registerDataSetObserver(DataSetObserver observer) {
		if (datasetObservers == null) {
			datasetObservers = new LinkedList<DataSetObserver>();
		}
		datasetObservers.add(observer);
	}

	public void unregisterDataSetObserver(DataSetObserver observer) {
		if (datasetObservers != null) {
			datasetObservers.remove(observer);
		}
	}

	/**
	 * Notifies observers about data changing
	 */
	protected void notifyDataChangedEvent() {
		if (datasetObservers != null) {
			for (DataSetObserver observer : datasetObservers) {
				observer.onChanged();
			}
		}
	}

	/**
	 * Notifies observers about invalidating data
	 */
	protected void notifyDataInvalidatedEvent() {
		if (datasetObservers != null) {
			for (DataSetObserver observer : datasetObservers) {
				observer.onInvalidated();
			}
		}
	}

    @Override
    public void setScrollingScope(int floorIndex, int upperIndex) {
        this.scopeFloorIndex = floorIndex;
        this.scopeUpperIndex = upperIndex;
    }

    @Override
    public int getScopeFloorIndex() {
        return scopeFloorIndex;
    }

    @Override
    public int getScopeUpperIndex() {
        return scopeUpperIndex;
    }
}